/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import com.sun.javafx.scene.text.HitInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Point2D;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.ui.controls.styledtext.DecorationStrategyFactory;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNode;
import org.eclipse.fx.ui.controls.styledtext.model.DecorationStrategy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TextNodeSingle
extends Pane
implements TextNode {
    private static final @NonNull CssMetaData<TextNodeSingle, @NonNull Paint> FILL = new CssMetaData<TextNodeSingle, Paint>("-fx-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

        public boolean isSettable(TextNodeSingle styleable) {
            return !styleable.fillProperty().isBound();
        }

        public StyleableProperty<@NonNull Paint> getStyleableProperty(TextNodeSingle styleable) {
            return (StyleableProperty)styleable.fill;
        }
    };
    final @NonNull ObjectProperty<@NonNull Paint> fill = new SimpleStyleableObjectProperty(FILL, (Object)this, "fill", (Object)Color.BLACK);
    private static String[] BASIC_STRING_CACHE = new String[256];
    private static final @NonNull DecorationStyleConverter CONVERTER = new DecorationStyleConverter();
    private static final @NonNull CssMetaData<TextNodeSingle, @Nullable DecorationStrategy> DECORATIONSTRATEGY = new CssMetaData<TextNodeSingle, DecorationStrategy>("-efx-decoration", (StyleConverter)CONVERTER, null){

        public boolean isSettable(TextNodeSingle node) {
            return !node.decorationStrategyProperty().isBound();
        }

        public StyleableProperty<@Nullable DecorationStrategy> getStyleableProperty(TextNodeSingle node) {
            return (StyleableProperty)node.decorationStrategyProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private @NonNull ObjectProperty<@Nullable DecorationStrategy> decorationStrategy = new SimpleStyleableObjectProperty(DECORATIONSTRATEGY, (Object)this, "decorationStrategy");
    private final IntegerProperty tabCharAdvance;
    private String originalText;
    private final Text text;
    private final List<Integer> tabPositions = new ArrayList<Integer>();

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(Region.getClassCssMetaData());
        styleables.add(DECORATIONSTRATEGY);
        styleables.add(FILL);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static String toString(char c) {
        String rv = null;
        if (c < BASIC_STRING_CACHE.length && (rv = BASIC_STRING_CACHE[c]) == null) {
            TextNodeSingle.BASIC_STRING_CACHE[c] = String.valueOf(c);
        }
        if (rv == null) {
            rv = String.valueOf(c);
        }
        return rv;
    }

    public final @NonNull ObjectProperty<@NonNull Paint> fillProperty() {
        return this.fill;
    }

    public final @NonNull Paint getFill() {
        return (Paint)this.fillProperty().get();
    }

    public final void setFill(@NonNull Paint color) {
        this.fillProperty().set((Object)color);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextNodeSingle.getClassCssMetaData();
    }

    public final @NonNull ObjectProperty<@Nullable DecorationStrategy> decorationStrategyProperty() {
        return this.decorationStrategy;
    }

    public final @Nullable DecorationStrategy getDecorationStrategy() {
        return (DecorationStrategy)this.decorationStrategyProperty().get();
    }

    public final void setDecorationStrategy(@Nullable DecorationStrategy strategy) {
        this.decorationStrategyProperty().set((Object)strategy);
    }

    public TextNodeSingle(String text, IntegerProperty tabCharAdvance) {
        this.tabCharAdvance = tabCharAdvance;
        this.originalText = text;
        this.text = new Text();
        this.text.setBoundsType(TextBoundsType.LOGICAL_VERTICAL_CENTER);
        this.text.fillProperty().bind(this.fillProperty());
        this.getStyleClass().add((Object)"styled-text-node");
        this.rebuildText(text);
        this.getChildren().add((Object)this.text);
        InvalidationListener listener = o -> this.rebuildText(this.originalText);
        this.parentProperty().addListener(e -> {
            if (this.getParent() == null) {
                this.tabCharAdvance.removeListener(listener);
            } else {
                this.tabCharAdvance.addListener(listener);
            }
        });
        this.decorationStrategy.addListener(this::handleDecorationChange);
    }

    private void handleDecorationChange(ObservableValue<? extends DecorationStrategy> observable, DecorationStrategy oldValue, DecorationStrategy newValue) {
        if (oldValue != null) {
            oldValue.unattach(this, this);
        }
        if (newValue != null) {
            newValue.attach(this, this);
        }
    }

    private void rebuildText(String text) {
        this.text.setText(this.processText(text));
    }

    private String processText(String text) {
        String tmp = text;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.tabCharAdvance.get()) {
            b.append(" ");
            ++i;
        }
        int position = -1;
        this.tabPositions.clear();
        while ((position = tmp.indexOf(9)) != -1) {
            tmp = tmp.replaceFirst("\t", b.toString());
            this.tabPositions.add(position);
        }
        return tmp;
    }

    @Override
    public void updateText(String text) {
        this.rebuildText(text);
        this.originalText = text;
    }

    @Override
    public int getCaretIndexAtPoint(Point2D point) {
        HitInfo info = this.text.impl_hitTestChar(this.text.sceneToLocal(this.localToScene(point)));
        if (info != null) {
            int idx = info.getInsertionIndex();
            int toRemove = 0;
            for (Integer i : this.tabPositions) {
                if (i <= idx && idx < i + this.tabCharAdvance.get()) {
                    toRemove += idx - i;
                    if ((idx - i) % this.tabCharAdvance.get() < this.tabCharAdvance.get() / 2) break;
                    ++idx;
                    break;
                }
                if (i >= idx) continue;
                toRemove += this.tabCharAdvance.get() - 1;
            }
            return idx -= toRemove;
        }
        return -1;
    }

    protected double computePrefWidth(double height) {
        return this.text.prefWidth(-1.0);
    }

    protected double computePrefHeight(double width) {
        return this.text.prefHeight(-1.0);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.text.resizeRelocate(0.0, 0.0, this.text.prefWidth(-1.0), this.text.prefHeight(-1.0));
    }

    @Override
    public String getText() {
        return this.originalText;
    }

    @Override
    public double getCharLocation(int index) {
        PathElement[] pathElements;
        int realIndex = index;
        for (Integer i : this.tabPositions) {
            if (i >= realIndex) continue;
            realIndex += this.tabCharAdvance.get() - 1;
        }
        this.text.setImpl_caretPosition(realIndex);
        PathElement[] pathElementArray = pathElements = this.text.getImpl_caretShape();
        int n = pathElements.length;
        int n2 = 0;
        while (n2 < n) {
            PathElement e = pathElementArray[n2];
            if (e instanceof MoveTo) {
                double x = this.localToParent(((MoveTo)e).getX(), 0.0).getX();
                return x;
            }
            ++n2;
        }
        return 0.0;
    }

    static class DecorationStyleConverter
    extends StyleConverter<ParsedValue<?, DecorationStrategy>, DecorationStrategy> {
        private static Map<String, DecorationStrategyFactory> FACTORIES;

        DecorationStyleConverter() {
        }

        public DecorationStrategy convert(ParsedValue<ParsedValue<?, DecorationStrategy>, DecorationStrategy> value, Font font) {
            String type;
            DecorationStrategyFactory strategy;
            String definition = "" + value.getValue();
            if (FACTORIES == null) {
                FACTORIES = ServiceUtils.getServiceList(((Object)((Object)this)).getClass(), DecorationStrategyFactory.class).stream().sorted((f1, f2) -> -1 * Integer.compare(f1.getRanking(), f2.getRanking())).collect(Collectors.toMap(f -> f.getDecorationStrategyName(), f -> f));
            }
            if ((strategy = FACTORIES.get(type = definition.contains("(") ? definition.substring(0, definition.indexOf(40)) : String.valueOf(definition))) != null) {
                return strategy.create(definition.contains("(") ? definition.substring(definition.indexOf(40) + 1, definition.lastIndexOf(41)) : null);
            }
            return null;
        }
    }
}

