/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.services.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.Subscription;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface UISynchronize {
    public <V> V syncExec(Callable<V> var1, V var2);

    public void syncExec(Runnable var1);

    public <V> Future<V> asyncExec(Callable<V> var1);

    public void asyncExec(Runnable var1);

    public <T> @Nullable T block(@NonNull BlockCondition<T> var1);

    public Subscription scheduleExecution(long var1, Runnable var3);

    public <T> CompletableFuture<T> scheduleExecution(long var1, Callable<T> var3);

    public static class BlockCondition<T> {
        List<Callback<T>> callbacks = new ArrayList<Callback<T>>();
        private boolean isBlocked = true;

        public Subscription subscribeUnblockedCallback(final Callback<T> r) {
            if (!this.isBlocked) {
                throw new IllegalStateException();
            }
            this.callbacks.add(r);
            return new Subscription(){

                public void dispose() {
                    callbacks.remove(r);
                }
            };
        }

        public boolean isBlocked() {
            return this.isBlocked;
        }

        public void release(T value) {
            for (Callback<T> r : this.callbacks) {
                r.call(value);
            }
            this.callbacks.clear();
            this.isBlocked = false;
        }
    }
}

