/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.services.resources;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javafx.scene.Node;
import javafx.scene.image.Image;
import org.eclipse.fx.core.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface GraphicsLoader {
    public @Nullable Image getImage(@NonNull URI var1);

    public @Nullable Node getGraphicsNode(@NonNull URI var1);

    public static class Util {
        public static @NonNull Map<String, String> parseQuery(@NonNull URI uri) {
            HashMap<String, String> params = new HashMap<String, String>();
            StringTokenizer tk = new StringTokenizer(uri.query(), "&");
            while (tk.hasMoreTokens()) {
                String element = tk.nextToken();
                int idx = element.indexOf(61);
                params.put(element.substring(0, idx), element.substring(idx + 1));
            }
            return params;
        }

        public static @Nullable String getQueryValue(@NonNull URI uri, @NonNull String name) {
            StringTokenizer tk = new StringTokenizer(uri.query(), "&");
            String searchValue = String.valueOf(name) + "=";
            while (tk.hasMoreTokens()) {
                String element = tk.nextToken();
                if (!element.startsWith(searchValue)) continue;
                return element.substring(element.indexOf(61) + 1);
            }
            return null;
        }

        public static @Nullable String suffix(@NonNull URI uri) {
            String last = uri.lastSegment();
            if (last == null) {
                return null;
            }
            int idx = last.lastIndexOf(46);
            if (idx != -1) {
                return last.substring(idx + 1).toLowerCase();
            }
            return null;
        }
    }
}

