/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.eclipse.equinox.http.servlet.internal.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.RequestDispatcherAdaptor;
import org.osgi.service.http.HttpContext;

public class ServletContextAdaptor {
    private static final Map contextToHandlerMethods = ServletContextAdaptor.createContextToHandlerMethods();
    private final ServletContext servletContext;
    final HttpContext httpContext;
    private final AccessControlContext acc;
    private final ProxyContext proxyContext;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static Map createContextToHandlerMethods() {
        HashMap<Method, Method> methods = new HashMap<Method, Method>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.http.servlet.internal.ServletContextAdaptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method[] handlerMethods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < handlerMethods.length) {
            Method handlerMethod = handlerMethods[i];
            String name = handlerMethod.getName();
            Class<?>[] parameterTypes = handlerMethod.getParameterTypes();
            try {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("javax.servlet.ServletContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method method = clazz2.getMethod(name, parameterTypes);
                methods.put(method, handlerMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            ++i;
        }
        return methods;
    }

    public ServletContextAdaptor(ProxyContext proxyContext, ServletContext servletContext, HttpContext httpContext, AccessControlContext acc) {
        this.servletContext = servletContext;
        this.httpContext = httpContext;
        this.acc = acc;
        this.proxyContext = proxyContext;
    }

    public ServletContext createServletContext() {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("javax.servlet.ServletContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class[] interfaces = classArray;
        InvocationHandler invocationHandler = this.createInvocationHandler();
        return (ServletContext)Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
    }

    private InvocationHandler createInvocationHandler() {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return ServletContextAdaptor.this.invoke(proxy, method, args);
            }
        };
    }

    Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method m = (Method)contextToHandlerMethods.get(method);
        if (m != null) {
            return m.invoke((Object)this, args);
        }
        return method.invoke((Object)this.servletContext, args);
    }

    public Set getResourcePaths(String name) {
        if (name == null || !name.startsWith("/")) {
            return null;
        }
        try {
            Class<?> clazz = this.httpContext.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method getResourcePathsMethod = clazz.getMethod("getResourcePaths", classArray);
            if (!getResourcePathsMethod.isAccessible()) {
                ((AccessibleObject)getResourcePathsMethod).setAccessible(true);
            }
            return (Set)getResourcePathsMethod.invoke((Object)this.httpContext, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getAttribute(String attributeName) {
        Dictionary attributes = this.proxyContext.getContextAttributes(this.httpContext);
        return attributes.get(attributeName);
    }

    public Enumeration getAttributeNames() {
        Dictionary attributes = this.proxyContext.getContextAttributes(this.httpContext);
        return attributes.keys();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        Dictionary attributes = this.proxyContext.getContextAttributes(this.httpContext);
        attributes.put(attributeName, attributeValue);
    }

    public void removeAttribute(String attributeName) {
        Dictionary attributes = this.proxyContext.getContextAttributes(this.httpContext);
        attributes.remove(attributeName);
    }

    public String getMimeType(String name) {
        String mimeType = this.httpContext.getMimeType(name);
        return mimeType != null ? mimeType : this.servletContext.getMimeType(name);
    }

    public URL getResource(final String name) {
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ServletContextAdaptor.this.httpContext.getResource(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            this.servletContext.log(e.getException().getMessage(), (Throwable)e.getException());
            return null;
        }
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                this.servletContext.log("Error opening stream for resource '" + name + "'", (Throwable)e);
            }
        }
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String arg0) {
        return new RequestDispatcherAdaptor(this.servletContext.getNamedDispatcher(arg0));
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return new RequestDispatcherAdaptor(this.servletContext.getRequestDispatcher(String.valueOf(this.proxyContext.getServletPath()) + arg0));
    }
}

