/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 			Andrea Zoppello (Engineering Group) - initial API and implementation and/or initial documentation
 * 			Gianfranco Boccalon (Engineering Group) - initial API and implementation and/or initial documentation
 *          Luca Rossato ( Engineering Group ) - initial API and implementation and/or initial documentation
 *          Luca Barozzi ( Engineering Group ) - initial API and implementation and/or initial documentation
 *  		Antonietta Miele ( Engineering Group ) - initial API and implementation and/or initial documentation
 *******************************************************************************/

package org.eclipse.ebpm.connectors.http.ssl;

import java.security.Security;

/**
 * This class contains all parameters of a KeyStore or a Truststore
 * 
 * 
 * @author Andrea Zoppello 
 */
public class KeyStoreBean {

	private String uri;

	private String password;
    private String type = "JKS";
    private String keyManagerFactoryAlgorithm;
    
  

    public KeyStoreBean(String keyManagerFactoryAlgorithmPropertyName) {
        keyManagerFactoryAlgorithm = Security.getProperty(keyManagerFactoryAlgorithmPropertyName);
        if (keyManagerFactoryAlgorithm == null) 
               keyManagerFactoryAlgorithm = "SunX509";
    }

   
   
    public String getKeyManagerFactoryAlgorithm() {
        return keyManagerFactoryAlgorithm;
    }

   
    public void setKeyManagerFactoryAlgorithm(String algorithm) {
        this.keyManagerFactoryAlgorithm = algorithm;
    }


    public String getUri() {
		return uri;
	}


	public void setUri(String uri) {
		this.uri = uri;
	}


	public String getPassword() {
		return password;
	}



	public void setPassword(String password) {
		this.password = password;
	}



	public String getType() {
		return type;
	}



	public void setType(String type) {
		this.type = type;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		KeyStoreBean other = (KeyStoreBean) obj;
		if (keyManagerFactoryAlgorithm == null) {
			if (other.keyManagerFactoryAlgorithm != null)
				return false;
		} else if (!keyManagerFactoryAlgorithm
				.equals(other.keyManagerFactoryAlgorithm))
			return false;
		if (password == null) {
			if (other.password != null)
				return false;
		} else if (!password.equals(other.password))
			return false;
		if (type == null) {
			if (other.type != null)
				return false;
		} else if (!type.equals(other.type))
			return false;
		if (uri == null) {
			if (other.uri != null)
				return false;
		} else if (!uri.equals(other.uri))
			return false;
		return true;
	}
	
}
