/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 			Andrea Zoppello (Engineering Group) - initial API and implementation and/or initial documentation
 * 			Gianfranco Boccalon (Engineering Group) - initial API and implementation and/or initial documentation
 *          Luca Rossato ( Engineering Group ) - initial API and implementation and/or initial documentation
 *          Luca Barozzi ( Engineering Group ) - initial API and implementation and/or initial documentation
 *  		Antonietta Miele ( Engineering Group ) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebpm.connectors.http.handlers;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.ebpm.connectors.http.HttpServerManager;
import org.eclipse.jetty.http.HttpMethods;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.StringUtil;

public class ServerStatusHandler extends AbstractHandler {

	@Override
	public void handle(String target, Request arg1, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		if (response.isCommitted() || HttpConnection.getCurrentConnection().getRequest().isHandled()) {
            return;
        }
		        
        String method = request.getMethod();

        if (!method.equals(HttpMethods.GET) || !request.getRequestURI().equals("/")) {
            response.sendError(404);
            return;
        }

        response.setStatus(404);
        response.setContentType(MimeTypes.TEXT_HTML);

        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);

        String uri = request.getRequestURI();
        uri = StringUtil.replace(uri, "<", "&lt;");
        uri = StringUtil.replace(uri, ">", "&gt;");

        writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
        writer.write("No service matched or handled this request.<BR>");
        writer.write("Known services are: <ul>");

        HttpServerManager.writeStatus(writer);
        
        writer.write("\n</BODY>\n</HTML>\n");
        writer.flush();
        response.setContentLength(writer.size());
        OutputStream out = response.getOutputStream();
        writer.writeTo(out);
        out.close();
		
	}

}

