/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event.mapper;

import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class EventAdapter {
    final EventAdmin eventAdmin;

    public EventAdapter(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public abstract Event convert();

    public void redeliver() {
        Event converted = this.convert();
        if (converted != null) {
            this.redeliverInternal(converted);
        }
    }

    protected void redeliverInternal(Event converted) {
        this.eventAdmin.postEvent(converted);
    }

    public void putBundleProperties(Hashtable properties, Bundle bundle) {
        properties.put("bundle.id", new Long(bundle.getBundleId()));
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            properties.put("bundle.symbolicName", symbolicName);
        }
        properties.put("bundle", bundle);
    }

    public void putExceptionProperties(Hashtable properties, Throwable t) {
        properties.put("exception", t);
        properties.put("exception.class", t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            properties.put("exception.message", t.getMessage());
        }
    }

    public void putServiceReferenceProperties(Hashtable properties, ServiceReference ref) {
        Object o2;
        properties.put("service", ref);
        properties.put("service.id", ref.getProperty("service.id"));
        Object o = ref.getProperty("service.pid");
        if (o != null && o instanceof String) {
            properties.put("service.pid", o);
        }
        if ((o2 = ref.getProperty("objectClass")) != null && o2 instanceof String[]) {
            properties.put("service.objectClass", o2);
        }
    }

    public String[] classes2strings(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        String[] strings = new String[classes.length];
        int i = 0;
        while (i < classes.length) {
            strings[i] = classes[i].getName();
            ++i;
        }
        return strings;
    }
}

