/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.interceptors.xml;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.InterceptorChain;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.stax.StaxUtil;

public class StaxOutInterceptor
extends AbstractInterceptor {
    @Override
    public void handleMessage(Message message) {
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            throw new NullPointerException("OutputStream content not found");
        }
        try {
            XMLStreamWriter writer = StaxUtil.createWriter(os, "UTF-8");
            message.setContent(XMLStreamWriter.class, writer);
            InterceptorChain chain = message.get(InterceptorChain.class);
            chain.doIntercept(message);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }
}

