/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.interceptors.nmr;

import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.bindings.soap.model.wsdl1.Wsdl1SoapOperation;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.stax.StaxUtil;
import org.w3c.dom.Element;

public class NmrWSDL1Interceptor
extends AbstractInterceptor {
    private final boolean server;

    public NmrWSDL1Interceptor(boolean server) {
        this.server = server;
    }

    @Override
    public void handleMessage(Message message) {
        if (message.getContent(Exception.class) != null) {
            return;
        }
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        if (xmlReader != null) {
            message.setContent(Source.class, StaxUtil.createSource(xmlReader));
        }
    }

    protected Wsdl1SoapOperation getOperation(Message message) {
        Operation operation = message.get(Operation.class);
        if (operation == null) {
            throw new Fault("Operation not bound on this message");
        }
        if (!(operation instanceof Wsdl1SoapOperation)) {
            throw new Fault("Message is not bound to a WSDL 1.1 SOAP operation");
        }
        return (Wsdl1SoapOperation)operation;
    }

    protected Element getBodyElement(Message message) {
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        return xmlReader != null ? StaxUtil.createElement(xmlReader) : null;
    }
}

