/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.interceptors.nmr;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.ebpm.constants.SpagicConstants;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.core.SpagicUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.bindings.soap.SoapFault;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.QNameUtil;
import org.w3c.dom.DocumentFragment;

public class NmrInInterceptor
extends AbstractInterceptor {
    public static final String OPERATION_MEP = "MEP";
    private final boolean server;

    public NmrInInterceptor(boolean server) {
        this.server = server;
    }

    @Override
    public void handleMessage(Message message) {
        try {
            org.eclipse.ebpm.messaging.api.Message nm;
            Operation operation = message.get(Operation.class);
            if (this.server) {
                Exchange exchange = this.createExchange(message);
                if (operation != null) {
                    exchange.setOperation(operation.getName());
                }
                nm = exchange.getIn();
                message.setContent(Exchange.class, exchange);
            } else {
                Exchange exchange = message.getContent(Exchange.class);
                if (exchange == null) {
                    throw new IllegalStateException("Content of type " + Exchange.class + " not found on message");
                }
                if (message.getContent(Exception.class) == null) {
                    nm = exchange.getOut(true);
                } else {
                    exchange.setFault(exchange.getFault(true));
                    nm = exchange.getFault();
                }
            }
            this.toNMSHeaders(nm, message);
            this.toNMSAttachments(nm, message);
            nm.setSecuritySubject(message.get(Subject.class));
            this.getContent(nm, message);
            message.setContent(Message.class, nm);
        }
        catch (Exception e) {
            if (((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                Exchange exchange = message.getContent(Exchange.class);
                org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)e)) + "</ERROR>");
                exchange.setOut(out);
            }
            throw new RuntimeException(e);
        }
    }

    private Exchange createExchange(Message message) throws Exception {
        Operation operation = message.get(Operation.class);
        URI mep = operation != null ? operation.getMep() : (URI)message.get(OPERATION_MEP);
        if (mep == null) {
            if (((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                Exchange exchange = message.getContent(Exchange.class);
                org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)new NullPointerException("MEP not found"))) + "</ERROR>");
                exchange.setOut(out);
                return exchange;
            }
            throw new NullPointerException("MEP not found");
        }
        String sender = (String)message.get("SPAGIC_SENDER");
        String target = (String)message.get("SPAGIC_TARGET");
        Object exchange = null;
        if (mep.equals(SpagicConstants.IN_ONLY_URI)) {
            return ExchangeUtils.createExchange((String)sender, (String)target, (Pattern)Pattern.InOnly);
        }
        if (mep.equals(SpagicConstants.IN_OUT_URI)) {
            return ExchangeUtils.createExchange((String)sender, (String)target, (Pattern)Pattern.InOut);
        }
        throw new RuntimeException("Unable to Create Exchange");
    }

    private void toNMSHeaders(org.eclipse.ebpm.messaging.api.Message normalizedMessage, Message soapMessage) {
        HashMap<String, DocumentFragment> headers = new HashMap<String, DocumentFragment>();
        for (Map.Entry<QName, DocumentFragment> entry : soapMessage.getSoapHeaders().entrySet()) {
            headers.put(QNameUtil.toString(entry.getKey()), entry.getValue());
        }
        normalizedMessage.setHeader("soap.headers", headers);
        normalizedMessage.setHeader("nmr.messaging.protocol.headers", soapMessage.getTransportHeaders());
    }

    private void toNMSAttachments(org.eclipse.ebpm.messaging.api.Message normalizedMessage, Message soapMessage) {
        for (Map.Entry<String, DataHandler> entry : soapMessage.getAttachments().entrySet()) {
            normalizedMessage.addAttachment(entry.getKey(), (Object)entry.getValue());
        }
    }

    private void getContent(org.eclipse.ebpm.messaging.api.Message normalizedMessage, Message message) {
        Exception e = message.getContent(Exception.class);
        if (e == null) {
            Source source = message.getContent(Source.class);
            normalizedMessage.setBody(SpagicUtils.toString((Source)source));
        } else if (e instanceof SoapFault) {
            SoapFault fault = (SoapFault)e;
            normalizedMessage.setBody(fault.getDetails());
            normalizedMessage.setHeader("spagic.soap.fault.code", (Object)fault.getCode().toString());
            normalizedMessage.setHeader("spagic.soap.fault.node", (Object)fault.getNode().toString());
            normalizedMessage.setHeader("spagic.soap.fault.reason", (Object)fault.getReason());
            normalizedMessage.setHeader("spagic.soap.fault.role", (Object)fault.getRole().toString());
            normalizedMessage.setHeader("spagic.soap.fault.subcode", (Object)fault.getSubcode().toString());
        }
    }
}

