/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.http.interceptors;

import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.bindings.http.interceptors.IriDecoderHelper;
import org.eclipse.ebpm.soap.bindings.http.model.Wsdl2HttpBinding;
import org.eclipse.ebpm.soap.bindings.http.model.Wsdl2HttpOperation;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;

public class HttpInOperationInterceptor
extends AbstractInterceptor {
    @Override
    public void handleMessage(Message message) {
        Binding binding = message.get(Binding.class);
        if (!(binding instanceof Wsdl2HttpBinding)) {
            return;
        }
        Wsdl2HttpBinding httpBinding = (Wsdl2HttpBinding)binding;
        String uri = message.getTransportHeaders().get("REQUEST_URI");
        if (uri == null) {
            throw new Fault("Transport header not set: REQUEST_URI");
        }
        String mth = message.getTransportHeaders().get("REQUEST_METHOD");
        if (mth == null) {
            throw new Fault("Transport header not set: REQUEST_METHOD");
        }
        for (Wsdl2HttpOperation operation : httpBinding.getOperations()) {
            String path2;
            if (!mth.equalsIgnoreCase(operation.getHttpMethod())) continue;
            String loc = IriDecoderHelper.combine(binding.getLocation(), operation.getHttpLocation());
            String path1 = this.getUriPath(uri);
            if (!this.matchPath(path1, path2 = this.getUriPath(loc))) continue;
            message.put(Operation.class, operation);
            return;
        }
    }

    private boolean matchPath(String path, String template) {
        int idx = template.indexOf(123);
        while (idx >= 0 && template.charAt(idx + 1) == '{') {
            idx = template.indexOf(123, idx + 2);
        }
        if (idx > 0) {
            return path.regionMatches(0, template, 0, idx - 1);
        }
        return path.equals(template);
    }

    private String getUriPath(String uri) {
        int idx = uri.indexOf("://");
        int idx2 = uri.indexOf(47, idx + 3);
        return uri.substring(idx2 + 1);
    }
}

