/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.quartz;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ebpm.connectors.quartz.adapters.DefaultQuartzAdapter;
import org.eclipse.ebpm.connectors.quartz.adapters.IQuartzAdapter;
import org.eclipse.ebpm.connectors.quartz.support.CronTriggerBean;
import org.eclipse.ebpm.connectors.quartz.support.JobDetailBean;
import org.eclipse.ebpm.connectors.quartz.support.SimpleTriggerBean;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.core.routing.IMessageRouter;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzConnector
extends AbstractSpagicConnector {
    protected Logger logger = LoggerFactory.getLogger(QuartzConnector.class);
    private Scheduler scheduler;
    private SchedulerFactory factory;
    private JobDetail jobDetail;
    private Map<String, Calendar> calendars;
    private List<Trigger> triggers = new ArrayList<Trigger>();
    private Trigger trigger;
    private IQuartzAdapter adapter = null;

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public void setJobDetail(JobDetail job) {
        this.jobDetail = job;
    }

    public Map<String, Calendar> getCalendars() {
        return this.calendars;
    }

    public void setCalendars(Map<String, Calendar> calendars) {
        this.calendars = calendars;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public IQuartzAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(IQuartzAdapter adapter) {
        this.adapter = adapter;
    }

    public void init() {
        String triggerType = this.propertyConfigurator.getString("triggerType");
        boolean flgInsertJobDetail = this.propertyConfigurator.getBoolean("insertJobDetail", Boolean.valueOf(false));
        try {
            if (triggerType.equals("cron")) {
                String cronExpression = this.propertyConfigurator.getString("cronExpression");
                CronTriggerBean cronTrigger = new CronTriggerBean();
                cronTrigger.setCronExpression(cronExpression);
                cronTrigger.setName(this.getSpagicId());
                this.triggers.add((Trigger)cronTrigger);
            } else if (triggerType.equals("simple")) {
                Integer repeatCount = this.propertyConfigurator.getInteger("repeatCount");
                Long repeatInterval = this.propertyConfigurator.getLong("repeatInterval");
                long ctime = System.currentTimeMillis();
                SimpleTriggerBean simpleTrigger = new SimpleTriggerBean();
                simpleTrigger.setName(this.getSpagicId());
                simpleTrigger.setRepeatCount(repeatCount);
                simpleTrigger.setRepeatInterval(repeatInterval);
                simpleTrigger.setStartTime(new Date(ctime));
                this.triggers.add((Trigger)simpleTrigger);
            }
            if (flgInsertJobDetail) {
                String jobName = this.propertyConfigurator.getString("jobName");
                String jobGroup = this.propertyConfigurator.getString("jobGroup");
                String jobDescription = this.propertyConfigurator.getString("jobDescription");
                this.jobDetail = new JobDetailBean();
                this.jobDetail.setName(jobName);
                this.jobDetail.setGroup(jobGroup);
                this.jobDetail.setDescription(jobDescription);
            }
            if (this.scheduler == null) {
                if (this.factory == null) {
                    this.factory = new StdSchedulerFactory();
                }
                this.scheduler = this.factory.getScheduler();
            }
            this.scheduler.getContext().setAllowsTransientData(true);
            this.scheduler.getContext().put((Object)this.spagicId, (Object)this);
            this.adapter = new DefaultQuartzAdapter();
            this.validate();
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void start() throws Exception {
        super.start();
        if (!this.scheduler.isStarted()) {
            this.scheduler.start();
        }
        this.jobDetail.getJobDataMap().put("org.spagic3.quartz.ComponentName", "spagic3.component.quartz");
        this.jobDetail.getJobDataMap().put("org.spagic3.quartz.EndpointName", this.getSpagicId());
        for (Map.Entry<String, Calendar> e : this.getCalendars().entrySet()) {
            this.scheduler.addCalendar(e.getKey(), e.getValue(), true, true);
        }
        this.scheduler.addJob(this.getJobDetail(), true);
        for (Trigger trg : this.getTriggers()) {
            boolean triggerExists;
            boolean bl = triggerExists = this.scheduler.getTrigger(trg.getName(), trg.getGroup()) != null;
            if (!triggerExists) {
                try {
                    this.scheduler.scheduleJob(trg);
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                    this.scheduler.rescheduleJob(trg.getName(), trg.getGroup(), trg);
                }
                continue;
            }
            this.scheduler.rescheduleJob(trg.getName(), trg.getGroup(), trg);
        }
    }

    public void stop() throws Exception {
        super.stop();
        for (Trigger trigger : this.getTriggers()) {
            this.scheduler.unscheduleJob(trigger.getName(), trigger.getGroup());
        }
        this.scheduler.deleteJob(this.getJobDetail().getName(), this.getJobDetail().getGroup());
        for (Map.Entry entry : this.getCalendars().entrySet()) {
            this.scheduler.deleteCalendar((String)entry.getKey());
        }
    }

    public void process(Exchange exchange) {
    }

    public void validate() throws Exception {
        if (this.jobDetail == null) {
            JobDetailBean j = new JobDetailBean();
            j.setName(this.getSpagicId());
            j.setDescription(this.getSpagicId());
            this.jobDetail = j;
        }
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
        }
        if (this.trigger != null && this.triggers != null && this.triggers.size() > 0) {
            throw new Exception("trigger and triggers can not be set at the same time");
        }
        if (this.trigger != null) {
            this.triggers.add(this.trigger);
        }
        if (this.calendars == null) {
            this.calendars = new HashMap<String, Calendar>();
        }
        for (Trigger t : this.triggers) {
            if (t.getCalendarName() != null && this.calendars.get(t.getCalendarName()) == null) {
                throw new Exception("Trigger references an unknown calendar " + t.getCalendarName());
            }
            t.setJobName(this.jobDetail.getName());
            t.setJobGroup(this.jobDetail.getGroup());
        }
    }

    public void onJobExecute(JobExecutionContext context) throws JobExecutionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Firing Quartz Job with context: " + context);
        }
        try {
            Exchange exchange = this.createInOnlyExchange();
            Message inMessage = exchange.getIn(true);
            this.getAdapter().populateNormalizedMessage(inMessage, context);
            exchange.setIn(inMessage);
            IMessageRouter router = this.getMessageRouter();
            if (!router.isServiceRegistered(this.target)) {
                this.logger.warn("Target Service [" + this.target + "] is not Registere cannot fire message");
            } else {
                this.send(exchange);
            }
        }
        catch (Exception e) {
            this.logger.error("Error in Exection of job " + e.getMessage(), (Throwable)e);
        }
    }
}

