/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.xsdvalidator;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateComponentSAXErrorHandler
implements ErrorHandler {
    private String rootElementName;
    private String ns;
    private int numberOfWarnings = 0;
    private int numberOfErrors = 0;
    private int numberOfFatalErrors = 0;
    private boolean requireExceptionTrace = false;
    private StringBuffer internalBuffer = new StringBuffer();

    public int getNumberOfWarnings() {
        return this.numberOfWarnings;
    }

    public void setNumberOfWarnings(int numberOfWarnings) {
        this.numberOfWarnings = numberOfWarnings;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public void setNumberOfErrors(int numberOfErrors) {
        this.numberOfErrors = numberOfErrors;
    }

    public int getNumberOfFatalErrors() {
        return this.numberOfFatalErrors;
    }

    public void setNumberOfFatalErrors(int numberOfFatalErrors) {
        this.numberOfFatalErrors = numberOfFatalErrors;
    }

    public boolean isRequireExceptionTrace() {
        return this.requireExceptionTrace;
    }

    public void setRequireExceptionTrace(boolean requireExceptionTrace) {
        this.requireExceptionTrace = requireExceptionTrace;
    }

    public ValidateComponentSAXErrorHandler(String rootElement, String namespace, boolean requireExceptionTrace) throws IllegalArgumentException {
        if (rootElement == null || rootElement.trim().length() == 0) {
            throw new IllegalArgumentException("RootElement must be a Valid String");
        }
        this.rootElementName = rootElement;
        this.ns = namespace;
        this.requireExceptionTrace = requireExceptionTrace;
    }

    public String encloseInWarning(String msg) {
        return "<warning>" + msg + "</warning>";
    }

    public String encloseInError(String msg) {
        return "<error>" + msg + "</error>";
    }

    public String ecloseInFatal(String msg) {
        return "<fatalError>" + msg + "</fatalError>";
    }

    public String encloseInCDATA(String msg) {
        return "<![CDATA[" + msg + "]]>";
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        ++this.numberOfWarnings;
        String warningXML = this.encloseInWarning(this.encloseInCDATA(this.saxExceptionToErrorMessage(e, this.requireExceptionTrace)));
        this.internalBuffer.append(warningXML);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        ++this.numberOfErrors;
        String errorXML = this.encloseInError(this.encloseInCDATA(this.saxExceptionToErrorMessage(e, this.requireExceptionTrace)));
        this.internalBuffer.append(errorXML);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        ++this.numberOfFatalErrors;
        String fatalErrorXML = this.ecloseInFatal(this.encloseInCDATA(this.saxExceptionToErrorMessage(e, this.requireExceptionTrace)));
        this.internalBuffer.append(fatalErrorXML);
    }

    private String saxExceptionToErrorMessage(SAXParseException e, boolean appendStackTrace) {
        if (appendStackTrace) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
        return e.getLocalizedMessage();
    }

    public String openTagForElementName(String name, String namespace) {
        StringBuffer buff = new StringBuffer().append("<").append(name);
        if (namespace != null && namespace.trim().length() > 0) {
            buff.append(" xmlns=\"").append(namespace).append("\">");
        } else {
            buff.append(">");
        }
        return buff.toString();
    }

    public String closeTagForElementName(String name) {
        return "</" + name + ">";
    }

    public String messagesToXML() {
        StringBuffer messages = new StringBuffer();
        messages.append(this.openTagForElementName(this.rootElementName, this.ns));
        messages.append(this.closeTagForElementName(this.rootElementName));
        return this.messagesToXML();
    }

    public boolean mustStop() {
        return this.numberOfErrors > 0 || this.numberOfFatalErrors > 0;
    }
}

