/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.jdbc.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.ebpm.components.jdbc.config.JDBCParameterFactory;
import org.eclipse.ebpm.components.jdbc.config.QueryParameterConfig;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.core.util.SourceTransformer;
import org.eclipse.ebpm.xmlutil.DOM4JUtils;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JDBCQueryConfig {
    private static final Logger log = LoggerFactory.getLogger(JDBCQueryConfig.class);
    public static final String FAULT_FLOW = "Continue".intern();
    public static final String FAULT_SYSTEM = "Stop".intern();
    private String matchParamRegexp = "\\$\\w+";
    private String query;
    private ArrayList<QueryParameterConfig> queryParams;
    private boolean enrichMessage;
    private String xmlEnvelope;
    private String rowsXmlEnvelope = "rows";
    private String rowXmlEnvelope = "row";
    private String faultManagement;
    private Boolean columnNameAsAttribute = false;
    private Boolean valueAsAttribute = false;

    public boolean isEnrichMessage() {
        return this.enrichMessage;
    }

    public ArrayList<QueryParameterConfig> getQueryParams() {
        return this.queryParams;
    }

    public void setEnrichMessage(boolean enrichMessage) {
        this.enrichMessage = enrichMessage;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setQueryParams(ArrayList<QueryParameterConfig> queryParams) {
        this.queryParams = queryParams;
    }

    public String getXmlEnvelope() {
        return this.xmlEnvelope;
    }

    public void setXmlEnvelope(String xmlEnvelope) {
        this.xmlEnvelope = xmlEnvelope;
    }

    public Object[] getParamsFromInXml(Message in, List<String> orderedParameterNamesList, Map<String, QueryParameterConfig> paramConfigMap) throws Exception {
        log.debug(" Filling Parameters from Normalized Message");
        Object[] values = new Object[orderedParameterNamesList.size()];
        Document inMsgDoc = new SourceTransformer().toDOMDocument(in);
        EXMLUtils xmlUtils = new EXMLUtils(DOM4JUtils.getNamespaceContext((Document)inMsgDoc));
        JDBCParameterFactory factory = JDBCParameterFactory.getInstance();
        int i = 0;
        for (String parameterName : orderedParameterNamesList) {
            QueryParameterConfig pConfig = paramConfigMap.get(parameterName);
            values[i] = factory.initializeParameter(inMsgDoc, xmlUtils, pConfig);
            log.debug("Parameter[" + i + "] Name[" + parameterName + "] Values[" + i + "] ( Type: " + pConfig.getParamType() + ") XPath (" + pConfig.getXpath() + ")");
            ++i;
        }
        return values;
    }

    public String getMatchParamRegexp() {
        return this.matchParamRegexp;
    }

    public void setMatchParamRegexp(String matchParamRegexp) {
        this.matchParamRegexp = matchParamRegexp;
    }

    public String getRowsXmlEnvelope() {
        return this.rowsXmlEnvelope;
    }

    public void setRowsXmlEnvelope(String rowsXmlEnvelope) {
        if (rowsXmlEnvelope != null && !rowsXmlEnvelope.trim().equals("")) {
            this.rowsXmlEnvelope = rowsXmlEnvelope;
        }
    }

    public String getRowXmlEnvelope() {
        return this.rowXmlEnvelope;
    }

    public void setRowXmlEnvelope(String rowXmlEnvelope) {
        if (rowXmlEnvelope != null && !rowXmlEnvelope.trim().equals("")) {
            this.rowXmlEnvelope = rowXmlEnvelope;
        }
    }

    public String getFaultManagement() {
        return this.faultManagement;
    }

    public void setFaultManagement(String faultManangement) {
        this.faultManagement = faultManangement;
    }

    public Boolean getColumnNameAsAttribute() {
        return this.columnNameAsAttribute;
    }

    public void setColumnNameAsAttribute(Boolean columnNameAsAttribute) {
        this.columnNameAsAttribute = columnNameAsAttribute;
    }

    public Boolean getValueAsAttribute() {
        return this.valueAsAttribute;
    }

    public void setValueAsAttribute(Boolean valueAsAttribute) {
        this.valueAsAttribute = valueAsAttribute;
    }
}

