/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.graph.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.ebpm.graph.util.IGraph;
import org.eclipse.ebpm.graph.util.IGraphProcessor;

public class Dot2SVGGraphProcessor
implements IGraphProcessor {
    private IGraph graph = null;
    private String dotExeLocation = "C:/Programmi/ATT/Graphviz/bin/dot";
    private String tempDirLocation = "C:/tmp";

    public Dot2SVGGraphProcessor(IGraph graph) {
        this.graph = graph;
        this.tempDirLocation = System.getProperty("java.io.tmpdir");
    }

    public Dot2SVGGraphProcessor(IGraph graph, String dotExeLocation) {
        this.graph = graph;
        this.dotExeLocation = dotExeLocation;
        this.tempDirLocation = System.getProperty("java.io.tmpdir");
    }

    public IGraph getGraph() {
        return this.graph;
    }

    public void setGraph(IGraph graph) {
        this.graph = graph;
    }

    public String getDotExeLocation() {
        return this.dotExeLocation;
    }

    public void setDotExeLocation(String dotExeLocation) {
        this.dotExeLocation = dotExeLocation;
    }

    public String getTempDirLocation() {
        return this.tempDirLocation;
    }

    public void setTempDirLocation(String tempDirLocation) {
        this.tempDirLocation = tempDirLocation;
    }

    @Override
    public byte[] processGraph() {
        byte[] img = null;
        try {
            String graphString = this.graph.toString();
            File fGraphDotSource = this.writeGraphToTemporaryFile(graphString);
            img = this.getSvgStream(fGraphDotSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    private File writeGraphToTemporaryFile(String str) throws IOException {
        File temp;
        try {
            File dir = new File(this.getTempDirLocation());
            if (!dir.exists() && !dir.mkdirs()) {
                throw new Exception("Unable to create Temporary Folder: " + this.getTempDirLocation());
            }
            temp = File.createTempFile("graph_", ".dot.tmp", dir);
            FileWriter fout = new FileWriter(temp);
            fout.write(str);
            fout.close();
        }
        catch (Exception exception) {
            System.err.println("Error: I/O error while writing the dot source to temp file!");
            return null;
        }
        return temp;
    }

    private byte[] getSvgStream(File dot) {
        byte[] img_stream = null;
        try {
            File dir = new File(this.getTempDirLocation());
            if (!dir.exists() && !dir.mkdirs()) {
                new IOException("Unable to create Graphviz temporary folder: " + this.getTempDirLocation());
            }
            File img = File.createTempFile("graph_", ".svg", dir);
            img.getAbsolutePath();
            Runtime rt = Runtime.getRuntime();
            String cmd = String.valueOf(this.getDotExeLocation()) + " -Tsvg " + dot.getAbsolutePath() + " -o" + img.getAbsolutePath();
            Process p = rt.exec(cmd);
            p.waitFor();
            FileInputStream in = new FileInputStream(img.getAbsolutePath());
            img_stream = new byte[in.available()];
            in.read(img_stream);
            in.close();
            if (!img.delete()) {
                System.err.println("Warning: " + img.getAbsolutePath() + " could not be deleted!");
            }
        }
        catch (IOException ioe) {
            System.err.println("Error:    in I/O processing of tempfile in dir " + this.getTempDirLocation() + "\n");
            System.err.println("       or in calling external command");
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            System.err.println("Error: the execution of the external program was interrupted");
            ie.printStackTrace();
        }
        return img_stream;
    }
}

