/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.monitoring;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebpm.databasemanager.IDatabaseManager;
import org.eclipse.ebpm.monitoring.MonitorEventConsumer;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorService
implements EventHandler {
    private static Logger logger = LoggerFactory.getLogger(MonitorService.class);
    private ComponentContext componentContext = null;
    private final AtomicReference<IDatabaseManager> dbManager = new AtomicReference<Object>(null);
    private BlockingQueue<Event> eventQueue = new LinkedBlockingDeque<Event>();
    private MonitorEventConsumer eventConsumer = null;

    protected void activate(ComponentContext componentContext) {
        logger.info(" Monitor Service - ACTIVATED");
        this.componentContext = componentContext;
        this.eventConsumer = new MonitorEventConsumer("MonitorQueueConsumer", this.eventQueue, this.getDatabaseManager());
        this.eventConsumer.start();
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info(" Monitor Service - DEACTIVATED");
    }

    public void handleEvent(Event event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted", (Throwable)e);
        }
    }

    public void setDatabaseManager(IDatabaseManager dbManager) {
        this.dbManager.set(dbManager);
    }

    public void unsetDatabaseManager(IDatabaseManager dbManager) {
        this.dbManager.compareAndSet(dbManager, null);
    }

    public IDatabaseManager getDatabaseManager() {
        return this.dbManager.get();
    }
}

