/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.metadb.customize;

import java.util.Map;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Session;

public class MetaDBSessionCustomizer
implements SessionCustomizer {
    public void customize(Session session) throws Exception {
        Map descriptors = session.getDescriptors();
        for (Object key : descriptors.keySet()) {
            String eclipseLinkDB;
            Object value = descriptors.get(key);
            ClassDescriptor cdesc = (ClassDescriptor)value;
            String seqName = cdesc.getSequenceNumberName();
            Sequence seq = cdesc.getSequence();
            if (seq == null) {
                seq = session.getDatasourcePlatform().getSequence(seqName);
            }
            if ((eclipseLinkDB = System.getProperty("eclipse.link.db")) != null && eclipseLinkDB.equalsIgnoreCase("postgres")) {
                if (!(seq instanceof NativeSequence)) continue;
                ((NativeSequence)seq).setShouldUseIdentityIfPlatformSupports(false);
                continue;
            }
            if (!(seq instanceof NativeSequence)) continue;
            ((NativeSequence)seq).setShouldUseIdentityIfPlatformSupports(true);
        }
    }
}

