/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.dirwatcher;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class GenericDeploymentDescriptor {
    private Hashtable<String, String> properties = new Hashtable();
    private Hashtable<String, String> attributes = new Hashtable();

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public GenericDeploymentDescriptor(Document document) {
        Element rootElement = document.getRootElement();
        List rootElAttributes = rootElement.attributes();
        String localAttributeName = null;
        for (Attribute anAttribute : rootElAttributes) {
            localAttributeName = anAttribute.getName();
            this.attributes.put(localAttributeName, anAttribute.getValue());
            if (!localAttributeName.equals("id") && !localAttributeName.equalsIgnoreCase("spagic.id") && !localAttributeName.equalsIgnoreCase("factory.name")) continue;
            this.properties.put(localAttributeName, anAttribute.getValue());
        }
        List propertiesNode = rootElement.elements("property");
        List xpropertiesNode = rootElement.elements("xproperty");
        for (Element pn : propertiesNode) {
            this.properties.put(pn.attributeValue("name"), pn.attributeValue("value"));
        }
        for (Element pn : xpropertiesNode) {
            Iterator elIterator = pn.elementIterator();
            if (elIterator.hasNext()) {
                String value = ((Element)elIterator.next()).asXML();
                this.properties.put(pn.attributeValue("name"), value);
                continue;
            }
            throw new IllegalStateException("XProperties error - an XProperty Must Have a Child Element");
        }
    }

    public String getFactoryName() {
        return this.attributes.get("factory.name");
    }

    public String getId() {
        return this.attributes.get("id");
    }

    public String getSpagicId() {
        return this.attributes.get("spagic.id");
    }
}

