/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.management.resources;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.core.ISpagicService;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServicesConnectorsStatusService
extends BaseSpagicService {
    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        int i;
        String s = in.getBodyText();
        if (s == null) {
            out.setBody("");
            return true;
        }
        HashMap<String, ServiceReference> serviceMap = new HashMap<String, ServiceReference>();
        HashMap<String, ServiceReference> connectorMap = new HashMap<String, ServiceReference>();
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(s));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        Document payload = db.parse(inputSource);
        inputSource.setCharacterStream(new StringReader(StringEscapeUtils.unescapeXml((String)payload.getElementsByTagName("payload").item(0).getTextContent())));
        Document res = db.parse(inputSource);
        if (res == null) {
            out.setBody("");
            return true;
        }
        StringBuilder filter = new StringBuilder("(&(objectClass=org.eclipse.ebpm.core.ISpagicService)(SPAGIC_TYPE=SPAGIC_SERVICE)");
        NodeList sListStatus = res.getElementsByTagName("sid");
        int max = sListStatus.getLength();
        if (max > 0) {
            filter.append("(|");
            int i2 = 0;
            while (i2 < max) {
                filter.append("(spagic.id=");
                filter.append(sListStatus.item(i2).getTextContent());
                filter.append(")");
                ++i2;
            }
            filter.append(")");
        }
        filter.append(")");
        ServiceReference[] services = this.context.getBundleContext().getServiceReferences(null, filter.toString());
        if (services != null) {
            max = services.length;
            int i3 = 0;
            while (i3 < max) {
                serviceMap.put((String)services[i3].getProperty("spagic.id"), services[i3]);
                ++i3;
            }
        }
        filter.delete(0, filter.length());
        filter.append("(&(objectClass=org.eclipse.ebpm.core.ISpagicService)(SPAGIC_TYPE=SPAGIC_CONNECTOR)");
        NodeList cListStatus = res.getElementsByTagName("cid");
        max = cListStatus.getLength();
        if (max > 0) {
            filter.append("(|");
            i = 0;
            while (i < max) {
                filter.append("(spagic.id=");
                filter.append(cListStatus.item(i).getTextContent());
                filter.append(")");
                ++i;
            }
            filter.append(")");
        }
        filter.append(")");
        services = this.context.getBundleContext().getServiceReferences(null, filter.toString());
        if (services != null) {
            max = services.length;
            i = 0;
            while (i < max) {
                connectorMap.put((String)services[i].getProperty("spagic.id"), services[i]);
                ++i;
            }
        }
        DOMSource source = new DOMSource(this.createResult(db, sListStatus, cListStatus, serviceMap, connectorMap));
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer transformer = tfactory.newTransformer();
        transformer.transform(source, result);
        Document response = db.newDocument();
        Element responseRoot = response.createElement("response");
        response.appendChild(responseRoot);
        responseRoot.setTextContent(stringWriter.getBuffer().toString());
        source = new DOMSource(responseRoot);
        stringWriter = new StringWriter();
        result = new StreamResult(stringWriter);
        tfactory = TransformerFactory.newInstance();
        transformer = tfactory.newTransformer();
        transformer.transform(source, result);
        out.setBody(stringWriter.getBuffer().toString());
        return true;
    }

    private Document createResult(DocumentBuilder db, NodeList sListStatus, NodeList cListStatus, Map<String, ServiceReference> serviceMap, Map<String, ServiceReference> connectorMap) throws DOMException, Exception {
        Document resultx = db.newDocument();
        Element root = resultx.createElement("rslt");
        resultx.appendChild(root);
        Element svcs = resultx.createElement("svcs");
        root.appendChild(svcs);
        int max = sListStatus.getLength();
        int i = 0;
        while (i < max) {
            String id = sListStatus.item(i).getTextContent();
            Element svx = resultx.createElement("svc");
            svx.setAttribute("id", id);
            ServiceReference s = serviceMap.get(id);
            if (s == null) {
                svx.setAttribute("status", "-1");
            } else {
                ISpagicService iss = (ISpagicService)this.context.getBundleContext().getService(s);
                svx.setAttribute("status", iss == null ? "-1" : (iss.isStarted() ? "1" : "0"));
            }
            svcs.appendChild(svx);
            ++i;
        }
        Element cnts = resultx.createElement("cnts");
        root.appendChild(cnts);
        max = cListStatus.getLength();
        int i2 = 0;
        while (i2 < max) {
            String id = cListStatus.item(i2).getTextContent();
            Element svx = resultx.createElement("cnt");
            svx.setAttribute("id", id);
            ServiceReference s = connectorMap.get(id);
            if (s == null) {
                svx.setAttribute("status", "-1");
            } else {
                ISpagicService iss = (ISpagicService)this.context.getBundleContext().getService(s);
                svx.setAttribute("status", iss == null ? "-1" : (iss.isStarted() ? "1" : "0"));
            }
            cnts.appendChild(svx);
            ++i2;
        }
        return resultx;
    }
}

