/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.util.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ebpm.service.model.ServiceModelHelper;
import org.eclipse.ebpm.util.resources.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
implements IResource {
    private Logger logger = LoggerFactory.getLogger(Resource.class);
    private static List<String> customProtocols = new ArrayList<String>();
    private String resource = null;

    static {
        customProtocols.add("xslt");
        customProtocols.add("xsl");
        customProtocols.add("script");
        customProtocols.add("wsdl");
        customProtocols.add("xsd");
        customProtocols.add("rule");
        customProtocols.add("script");
        customProtocols.add("pdf");
        customProtocols.add("resource");
        customProtocols.add("properties");
        customProtocols.add("keystore");
        customProtocols.add("schematron");
    }

    public Resource(String resource) {
        this.resource = resource;
    }

    @Override
    public InputStream openStream() {
        try {
            URI uri = new URI(this.resource);
            String scheme = uri.getScheme();
            ServiceModelHelper serviceModelHelper = new ServiceModelHelper();
            ServiceModelHelper.DeploySchemaHelper deploySchemaHelper = serviceModelHelper.getDeploySchemaByName(scheme);
            if (deploySchemaHelper != null) {
                String lastPart = uri.getHost();
                if (lastPart == null && (lastPart = uri.getSchemeSpecificPart()).startsWith("//")) {
                    lastPart = lastPart.substring(lastPart.lastIndexOf("//") + 2);
                }
                String resourceLocation = String.valueOf(System.getProperty("spagic.home")) + File.separator + deploySchemaHelper.getPath() + File.separator + lastPart;
                this.logger.info("Resource Resolved to " + resourceLocation);
                return new FileInputStream(resourceLocation);
            }
            return new FileInputStream(uri.getPath());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public URL asURL() {
        try {
            URI uri = new URI(this.resource);
            String scheme = uri.getScheme();
            if (customProtocols.contains(uri.getScheme())) {
                this.logger.info("Resolving resource uri [" + uri + "]");
                this.logger.info("Resolving resource uri [" + uri + "] - SPAGIC_HOME PROPERTY -> [" + System.getProperty("spagic.home") + "]");
                String uriHost = uri.getHost();
                this.logger.info("Resolving resource uri [" + uri + "] - uri.getHost() -> [" + uri.getHost() + "]");
                if (uriHost == null || uriHost.trim().length() == 0) {
                    String uriString = uri.toString();
                    uriHost = uriString.substring(uriString.lastIndexOf("/") + 1);
                }
                String resourceLocation = String.valueOf(System.getProperty("spagic.home")) + File.separator + "resources" + File.separator + scheme + File.separator + uriHost;
                this.logger.info("Resource Resolved to " + resourceLocation);
                File f = new File(resourceLocation);
                URI fileURI = f.toURI();
                return fileURI.toURL();
            }
            return uri.toURL();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String pathAsString() {
        try {
            URI uri = new URI(this.resource);
            String scheme = uri.getScheme();
            if (customProtocols.contains(uri.getScheme())) {
                String uriHost = uri.getHost();
                this.logger.info("Resolving resource uri [" + uri + "] - uri.getHost() -> [" + uri.getHost() + "]");
                if (uriHost == null || uriHost.trim().length() == 0) {
                    String uriString = uri.toString();
                    uriHost = uriString.substring(uriString.lastIndexOf("/") + 1);
                }
                String resourceLocation = String.valueOf(System.getProperty("spagic.home")) + File.separator + "resources" + File.separator + scheme + File.separator + uriHost;
                this.logger.info("Resource Resolved to " + resourceLocation);
                return resourceLocation;
            }
            return uri.getPath();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

