CREATE TABLE ID_GEN
  (
    "ID_NAME" VARCHAR2(100 BYTE),
    "ID_VAL"  NUMBER
  );

CREATE TABLE EBAM_EVENT (
  EVENT_ID INTEGER NOT NULL,
  NAME VARCHAR2(50) DEFAULT NULL,
  EXPRESSION VARCHAR2(1000) DEFAULT NULL,
  START_DATE TIMESTAMP(6) DEFAULT NULL,
  END_DATE TIMESTAMP(6) DEFAULT NULL,
  HANDLER_CLASS VARCHAR2(200) DEFAULT NULL,
  PERSIST INTEGER DEFAULT 1,
  PRIMARY KEY (EVENT_ID)
) ;


CREATE TABLE EBAM_RULES (
  RULE_ID INTEGER NOT NULL,
  EVENT_ID INTEGER,
  ROLE_TYPE_ID INTEGER NOT NULL,
  START_DATE TIMESTAMP(6) DEFAULT NULL,
  END_DATE TIMESTAMP(6) DEFAULT NULL,
  EXPRESSION CLOB DEFAULT NULL,
  SERVICE VARCHAR2(100) DEFAULT NULL,
  THRESHOLD_ID INTEGER,
  PRIMARY KEY (RULE_ID)
) ;


CREATE TABLE SERVICE (
  ID_SERVICE INTEGER NOT NULL,
  STATE INTEGER DEFAULT NULL,
  MONITOR_ENABLED char(1) DEFAULT NULL,
  STARTDATE TIMESTAMP(6) DEFAULT NULL,
  ENDDATE TIMESTAMP(6) DEFAULT NULL,
  NAME VARCHAR2(100) DEFAULT NULL,
  PRIMARY KEY (ID_SERVICE)
);


CREATE TABLE EBAM_MESSAGE (
  MESSAGE_ID INTEGER NOT NULL,
  ID_SERVICE INTEGER DEFAULT NULL,
  MESSAGE_TYPE_ID INTEGER NOT NULL,
  NAME VARCHAR2(100) DEFAULT NULL,
  DESCRIPTION VARCHAR2(200) DEFAULT NULL,
  XML_SCHEMA VARCHAR2(1000) DEFAULT NULL,
  START_DATE TIMESTAMP(6) DEFAULT NULL,
  END_DATE TIMESTAMP(6) DEFAULT NULL,
  ROOT_ELEMENT VARCHAR2(255) DEFAULT NULL,
  XSL VARCHAR2(1000) DEFAULT NULL,
  PRIMARY KEY (MESSAGE_ID)
) ;


CREATE TABLE EBAM_DATA_ATTRIBUTES (
  ATTRIBUTE_ID INTEGER NOT NULL,
  MESSAGE_ID INTEGER NOT NULL,
  NAME VARCHAR2(100) DEFAULT NULL,
  ATTR_TYPE VARCHAR2(100) DEFAULT NULL,
  EXPRESSION Clob,
  DATA_TYPE VARCHAR2(100) DEFAULT NULL,
  FATHER_ID INTEGER DEFAULT NULL,
  "LEVEL" INTEGER DEFAULT NULL,
  MESSAGE_NAME VARCHAR2(100) DEFAULT NULL,
  SERVICE_NAME VARCHAR2(100) DEFAULT NULL,    
  PRIMARY KEY (ATTRIBUTE_ID)
);

CREATE TABLE EBAM_EVENT_JOURNAL (
  EVENT_JOURNAL_ID INTEGER NOT NULL,
  TIMESTAMP TIMESTAMP(6) DEFAULT NULL,
  EVENT_DATA VARCHAR2(255) DEFAULT NULL,
  EVENT_ID INTEGER DEFAULT NULL,
  PRIMARY KEY (EVENT_JOURNAL_ID)
) ;

CREATE TABLE SERVICE_INSTANCE (
  ID_SERVICE_INSTANCE INTEGER NOT NULL,
  ID_SERVICE INTEGER  NOT NULL,
  ID_TARGET_SERVICE_INSTANCE INTEGER DEFAULT NULL,
  MESSAGE_ID VARCHAR2(50)  DEFAULT NULL,
  CORRELATION_ID VARCHAR2(50) DEFAULT NULL,
  STATE INTEGER NOT NULL,
  STARTDATE TIMESTAMP(6) NOT NULL,
  ENDDATE TIMESTAMP(6) DEFAULT NULL,
  LABEL VARCHAR2(255) NOT NULL,
  MARKER CHAR(1) DEFAULT NULL,
  MONITOR_CHECK CHAR(1) DEFAULT NULL,
  ERRORS_CHECK CHAR(1) DEFAULT NULL,
  ALARMS_CHECK CHAR(1) DEFAULT NULL,
  VIEWS_CHECK CHAR(1) DEFAULT NULL,
  USER_ID VARCHAR2(300) DEFAULT NULL,
  TS_UPDATE TIMESTAMP(6) DEFAULT NULL,
  RESOURCE_ID INTEGER ,
  PRIMARY KEY (ID_SERVICE_INSTANCE)
);


CREATE TABLE EBAM_JOURNAL (
  JOURNAL_ID INTEGER NOT NULL,
  START_DATE TIMESTAMP(6) DEFAULT NULL NOT NULL,
  ERROR VARCHAR2(255) DEFAULT NULL,
  EXECUTION_TIME TIMESTAMP(6) DEFAULT NULL,
  XML_DATA CLOB,
  PHASE_DESCR VARCHAR2(255) DEFAULT NULL,
  END_DATE TIMESTAMP(6) DEFAULT NULL NOT NULL,
  SERVICE_SRC_ORIG VARCHAR2(3000) DEFAULT NULL,
  RESPONSE CLOB,
  ALARM VARCHAR2(255) DEFAULT NULL,
  PHASE_PROG VARCHAR2(255) DEFAULT NULL,
  REQUEST CLOB,
  NAME VARCHAR2(255) DEFAULT NULL NOT NULL,
  STATE_DESCR VARCHAR2(255) DEFAULT NULL,
  TIMESTAMP_IN TIMESTAMP(6) DEFAULT NULL,
  PHASE_NAME VARCHAR2(255) DEFAULT NULL,
  WARNING VARCHAR2(255) DEFAULT NULL,
  MESSAGE_ID INTEGER DEFAULT NULL NOT NULL,
  ID_SERVICE_INSTANCE INTEGER DEFAULT NULL NOT NULL,
  SOURCE_NAME VARCHAR2(255) DEFAULT NULL NOT NULL,
  MARKER char(1) DEFAULT NULL,
  LABEL VARCHAR2(255) DEFAULT NULL NOT NULL,
  PRIMARY KEY (JOURNAL_ID),
  CONSTRAINT "EBAM_JOURNAL_UK1" UNIQUE ("LABEL")
);
 


CREATE TABLE EBAM_MESSAGE_CONTENT (
  MSG_CONTENT_ID INTEGER NOT NULL,
  NAME VARCHAR2(255) DEFAULT NULL,
  VALUE VARCHAR2(255) DEFAULT NULL,
  ATTRIBUTE_ID INTEGER NOT NULL,
  JOURNAL_ID INTEGER NOT NULL,
  FATHER_ID INTEGER DEFAULT NULL,
  DETAIL_LIST CLOB,
  DETAIL_XML CLOB,
  "LEVEL" INTEGER DEFAULT NULL,
  ID_SERVICE_INSTANCE INTEGER DEFAULT NULL,    
  PRIMARY KEY (MSG_CONTENT_ID),
  CONSTRAINT "EBAM_MESSAGE_CONTENT_UK1" UNIQUE ("ATTRIBUTE_ID", "JOURNAL_ID")
);

CREATE TABLE SBI_ALARM (
  ALARM_ID INTEGER NOT NULL,
  LABEL VARCHAR2(50) DEFAULT NULL,
  NAME VARCHAR2(50) DEFAULT NULL,
  DESCR VARCHAR2(200) DEFAULT NULL,
  TEXT VARCHAR2(1000) DEFAULT NULL,
  URL VARCHAR2(20) DEFAULT NULL,
  SINGLE_EVENT CHAR(1) DEFAULT NULL,
  AUTO_DISABLED CHAR(1) DEFAULT NULL,
  ID_THRESHOLD_VALUE INTEGER DEFAULT NULL,
  MODALITY_ID INTEGER DEFAULT NULL,
  DOCUMENT_ID INTEGER DEFAULT NULL,
  EVENT_ID INTEGER DEFAULT NULL,
  PRIMARY KEY (ALARM_ID)
);


CREATE TABLE SBI_ALARM_CONTACT (
  ALARM_CONTACT_ID INTEGER NOT NULL,
  NAME VARCHAR2(100) DEFAULT NULL,
  EMAIL VARCHAR2(100) DEFAULT NULL,
  MOBILE VARCHAR2(50) NOT NULL,
  RESOURCES VARCHAR2(200) DEFAULT NULL,
  PRIMARY KEY (ALARM_CONTACT_ID)
);

CREATE TABLE SBI_ALARM_DISTRIBUTION (
  ALARM_ID INTEGER NOT NULL,
  ALARM_CONTACT_ID INTEGER NOT NULL,
  PRIMARY KEY (ALARM_ID,ALARM_CONTACT_ID)
);

CREATE TABLE SBI_ALARM_EVENT (
  ALARM_EVENT_ID INTEGER NOT NULL ,
  EVENT_TS TIMESTAMP(6) DEFAULT NULL,
  RESOURCES VARCHAR2(255) DEFAULT NULL,
  RESOURCE_ID INTEGER DEFAULT NULL,
  THRESHOLD_VALUE VARCHAR2(255) DEFAULT NULL,
  KPI_NAME VARCHAR2(255) DEFAULT NULL,
  ACTIVE VARCHAR2(255) DEFAULT NULL,
  KPI_DESCRIPTION VARCHAR2(255) DEFAULT NULL,
  KPI_INSTANCE_ID INTEGER DEFAULT NULL,
  KPI_VALUE VARCHAR2(255) DEFAULT NULL,
  ALARM_ID INTEGER DEFAULT NULL,
  PRIMARY KEY (ALARM_EVENT_ID)
) ;

CREATE TABLE EBAM_MESSAGE_ENGINE (
  MESSAGE_ID INTEGER NOT NULL,
  VALUE_ID INTEGER DEFAULT NULL
) ;

CREATE TABLE EBAM_EVENT_ATTRIBUTES (
  EVENT_ATTR_ID INTEGER NOT NULL,
  EVENT_ID FLOAT(17) DEFAULT NULL,
  NAME VARCHAR2(50),
  EXPRESSION VARCHAR2(100),
  PRIMARY KEY (EVENT_ATTR_ID)
) ;

CREATE TABLE EBAM_EVENT_CONTENTS (
  EVENT_CONTENT_ID INTEGER NOT NULL,
  EVENT_JOURNAL_ID FLOAT(17) DEFAULT NULL,
  EVENT_ATTR_ID INTEGER NOT NULL,
  NAME VARCHAR2(100),
  VALUE VARCHAR2(100),
  PRIMARY KEY (EVENT_CONTENT_ID)
) ;
