/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.lang.reflect.Array;

public class EventQueue {
    public static int DEFAULT_QUEUE_LENGTH = 10;
    private Object lock = new Object();
    private Object[] items;
    private int queueLength;
    private int firstFreeSlot;
    private boolean shuttingDown = false;

    public EventQueue() {
        this(DEFAULT_QUEUE_LENGTH);
    }

    public EventQueue(int length) {
        this.queueLength = length;
        this.firstFreeSlot = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Object[] newItem) throws InterruptedException {
        int entriesToCopy = 0;
        if (newItem != null) {
            entriesToCopy = newItem.length;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.items == null) {
                this.items = (Object[])Array.newInstance(newItem[0].getClass(), this.queueLength);
                this.firstFreeSlot = 0;
            }
            while (!this.shuttingDown && entriesToCopy > 0) {
                if (this.freeSpace() == 0) {
                    try {
                        this.lock.wait();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedException("Queue is full");
                    }
                }
                this.items[this.firstFreeSlot] = newItem[newItem.length - entriesToCopy];
                ++this.firstFreeSlot;
                --entriesToCopy;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getItem() throws InterruptedException {
        Object[] rc = null;
        Object object = this.lock;
        synchronized (object) {
            while (!this.shuttingDown && this.isEmpty()) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedException("Queue is empty");
                }
            }
            if (!this.shuttingDown) {
                rc = (Object[])Array.newInstance(this.items[0].getClass(), this.size());
                int i = 0;
                while (i < this.size()) {
                    rc[i] = this.items[i];
                    ++i;
                }
                this.clear();
            }
            this.lock.notifyAll();
            return rc;
        }
    }

    public boolean isFull() {
        return this.firstFreeSlot == this.queueLength;
    }

    public boolean isEmpty() {
        return this.firstFreeSlot == 0;
    }

    public int size() {
        return this.firstFreeSlot;
    }

    public int freeSpace() {
        return this.queueLength - this.firstFreeSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isEmpty()) {
                this.lock.wait();
            }
            this.shuttingDown = true;
            this.lock.notifyAll();
        }
    }

    private void clear() {
        int i = 0;
        while (i < this.items.length) {
            this.items[i] = null;
            ++i;
        }
        this.firstFreeSlot = 0;
    }
}

