/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.util.AdapterUtilities;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AdapterConfigValidator {
    private static final String currentPlugin = "org.eclipse.hyades.logging.adapter";
    private static final String W3C_XML_Schema = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_Schema_Language = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String externalSchemaLocation = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String schemaLocation = "schema";
    private static final String namespacePrefix = "http://www.eclipse.org/hyades/schema/";
    private boolean isWorkbench = AdapterUtilities.isWorkbench();
    private IProcessUnit logger;
    private EventFactory eventFactory = null;
    static /* synthetic */ Class class$0;

    public AdapterConfigValidator(IProcessUnit inLogger) {
        this.logger = inLogger;
        if (this.logger != null) {
            this.logger.setLogger(inLogger);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getExternalSchemaLocationValues(boolean isEclipseEnvironment) throws AdapterException {
        String retValue = "";
        String fileSeparator = System.getProperty("file.separator");
        if (isEclipseEnvironment) {
            try {
                File[] files;
                Class<?> pathClass = Class.forName("org.eclipse.core.runtime.Path");
                Constructor<?> pathConstructor = pathClass.getConstructor(schemaLocation.getClass());
                Object path = pathConstructor.newInstance(schemaLocation);
                Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
                Class<?> pluginClass = Class.forName("org.eclipse.core.runtime.Plugin");
                Object plugin = platformClass.getMethod("getPlugin", currentPlugin.getClass()).invoke(null, currentPlugin);
                URL osgiUrl = (URL)pluginClass.getMethod("find", Class.forName("org.eclipse.core.runtime.IPath")).invoke(plugin, path);
                File f = new File(((URL)platformClass.getMethod("asLocalURL", osgiUrl.getClass()).invoke(null, osgiUrl)).getFile());
                if (!f.isDirectory() || (files = f.listFiles()).length <= 0) return retValue.trim();
                int i = 0;
                while (i < files.length) {
                    if (!files[i].isDirectory() && (files[i].getName().endsWith(".xsd") || files[i].getName().endsWith(".XSD"))) {
                        String namespace = namespacePrefix + files[i].getName();
                        retValue = String.valueOf(retValue) + " " + namespace + " " + files[i].toURI();
                    }
                    ++i;
                }
                return retValue.trim();
            }
            catch (Exception e) {
                throw new AdapterException(Messages.getString("HyadesGAValidation_Getting_Schemas_ERROR_", e.getMessage()));
            }
        } else if (System.getProperty("GLA_HOME") != null) {
            String schemasURLHome;
            File schemasDir;
            String glaHome = System.getProperty("GLA_HOME");
            if (glaHome.startsWith("\"") && glaHome.endsWith("\"")) {
                glaHome = glaHome.substring(1, glaHome.length() - 1);
            }
            if ((schemasDir = new File(schemasURLHome = String.valueOf(glaHome) + fileSeparator + schemaLocation)).isDirectory()) {
                File[] files = schemasDir.listFiles();
                if (files.length <= 0) return retValue.trim();
                int i = 0;
                while (i < files.length) {
                    if (!files[i].isDirectory() && (files[i].getName().endsWith(".xsd") || files[i].getName().endsWith(".XSD"))) {
                        String namespace = namespacePrefix + files[i].getName();
                        retValue = String.valueOf(retValue) + " " + namespace + " " + files[i].toURI();
                    }
                    ++i;
                }
                return retValue.trim();
            } else {
                this.logMessage(Messages.getString("HyadesGAValidation_GLAHome_Invalid_ERROR_", glaHome));
            }
            return retValue.trim();
        } else {
            this.logMessage(Messages.getString("HyadesGAValidation_No_GLAHome_ERROR_"));
        }
        return retValue.trim();
    }

    private DocumentBuilder getValidateDocumentBuilder() throws AdapterException, IOException {
        DocumentBuilder builder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute(JAXP_Schema_Language, W3C_XML_Schema);
                factory.setAttribute(externalSchemaLocation, this.getExternalSchemaLocationValues(this.isWorkbench));
                factory.setValidating(true);
            }
            catch (Exception exception) {
                CommonBaseEvent commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                commonBaseEvent.setSeverity((short)20);
                commonBaseEvent.setMsg(Messages.getString("HyadesGAValidation_Validation_Not_Supported_WARN_"));
                if (this.logger != null) {
                    this.logger.log(commonBaseEvent);
                }
                System.out.print(commonBaseEvent.getMsg());
            }
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException e) throws SAXException {
                    AdapterConfigValidator.this.logMessage(e, "Warning");
                }

                public void error(SAXParseException e) throws SAXException {
                    AdapterConfigValidator.this.logMessage(e, "Error");
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    AdapterConfigValidator.this.logMessage(e, "fatalError");
                }
            });
        }
        catch (ParserConfigurationException pce) {
            throw new AdapterException(pce.getMessage());
        }
        return builder;
    }

    public void validate(InputStream inAppStream) throws AdapterException {
        try {
            DocumentBuilder builder = this.getValidateDocumentBuilder();
            builder.parse(inAppStream);
        }
        catch (SAXException se) {
            throw new AdapterException(se.getMessage());
        }
        catch (Exception e) {
            throw new AdapterException(e.getMessage());
        }
    }

    public EventFactory getEventFactory() {
        if (this.eventFactory == null) {
            EventFactoryHome eventFactoryHome;
            EventFactoryContext eventFactoryContext = EventFactoryContext.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.hyades.logging.adapter.internal.util.AdapterConfigValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((eventFactoryHome = eventFactoryContext.getEventFactoryHome("org.eclipse.hyades.logging.adapter.internal.util.RuntimeEventXMLFileEventFactoryHomeImpl", clazz.getClassLoader())) != null) {
                this.eventFactory = eventFactoryHome.getEventFactory("org.eclipse.hyades.logging.adapter.impl.Component");
                this.eventFactory.setCompleteEvent(true);
            } else {
                this.eventFactory = EventFactoryContext.getInstance().getSimpleEventFactoryHome().getAnonymousEventFactory();
            }
        }
        return this.eventFactory;
    }

    public void logMessage(SAXParseException e, String type) {
        String msg = null;
        int severity = 0;
        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
        if (type.equals("fatalError")) {
            msg = Messages.getString("HyadesGAValidation_Fatal_ERROR_", e.getMessage());
            severity = 60;
        } else if (type.equals("Error")) {
            msg = Messages.getString("HyadesGAValidation_ERROR_", e.getMessage());
            severity = 50;
        } else if (type.equals("Warning")) {
            msg = Messages.getString("HyadesGAValidation_WARN_", e.getMessage());
            severity = 30;
        }
        event.setSeverity((short)severity);
        event.setMsg(msg);
        if (this.logger != null) {
            this.logger.log(event);
        } else {
            System.out.print(event.getMsg());
        }
    }

    public void logMessage(String msg) {
        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
        event.setSeverity((short)50);
        event.setMsg(msg);
        if (this.logger != null) {
            this.logger.log(event);
        } else {
            System.out.print(event.getMsg());
        }
    }
}

