/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.impl.tpt.timer;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import org.eclipse.equinox.internal.util.UtilActivator;
import org.eclipse.equinox.internal.util.impl.tpt.ServiceFactoryImpl;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.Executor;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.ThreadPoolFactoryImpl;
import org.eclipse.equinox.internal.util.impl.tpt.timer.TimerQueue;
import org.eclipse.equinox.internal.util.impl.tpt.timer.TimerQueueNode;
import org.eclipse.equinox.internal.util.pool.ObjectPool;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.equinox.internal.util.timer.TimerListener;

public class TimerImpl
implements Runnable {
    static Hashtable nodes;
    static ObjectPool nodePool;
    static ThreadPoolFactoryImpl threadPool;
    private TimerQueue queue;
    private boolean terminated = false;
    private Object sync = new Object();
    private Thread th;
    PrivilegedActionImpl action = null;

    public TimerImpl(ThreadPoolFactoryImpl threadPool) {
        nodePool = new ObjectPool(new TimerQueueNode(), 2, 4, 2);
        TimerImpl.threadPool = threadPool;
        nodes = new Hashtable(10);
        this.queue = new TimerQueue();
        try {
            this.th = ServiceFactoryImpl.privileged() ? this.getOne() : new Thread((Runnable)this, "[Timer] - Main Queue Handler");
            try {
                String str = UtilActivator.bc.getProperty("equinox.timer.priority");
                if (str != null) {
                    this.th.setPriority(Integer.parseInt(str));
                }
            }
            catch (Throwable throwable) {}
            this.th.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not start Timer thread!" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TimerQueueNode n = null;
        while (!this.terminated) {
            Object object = this.sync;
            synchronized (object) {
                if (n == null && this.queue.isEmpty()) {
                    try {
                        this.sync.wait();
                    }
                    catch (Exception exception) {}
                    if (this.queue.isEmpty() || this.terminated) {
                        continue;
                    }
                }
            }
            object = this.queue;
            synchronized (object) {
                n = this.queue.getMin();
                while (n != null && !n.enabled) {
                    this.queue.removeMin();
                    n.returnInPool();
                    n = this.queue.getMin();
                }
                if (n == null) {
                    continue;
                }
                long current = System.currentTimeMillis();
                if (n.runOn <= current) {
                    switch (n.type) {
                        case 0: {
                            threadPool.execute0(n, n.priority, n.getEName(), n.acc);
                            this.queue.removeMin();
                            nodes.remove(n);
                            break;
                        }
                        case 2: {
                            Thread th;
                            Executor e = threadPool.getExecutor();
                            if (e != null) {
                                e.setPriorityI(n.priority);
                                e.setRunnable(n, n.getEName(), threadPool, n.acc);
                            } else {
                                th = new Thread((Runnable)n, n.getEName());
                                th.setPriority(n.priority);
                                th.start();
                            }
                            this.queue.removeMin();
                            nodes.remove(n);
                            break;
                        }
                        case 1: {
                            threadPool.execute0(n, n.priority, n.getEName(), n.acc);
                            n.runOn += n.period;
                            if (n.runOn < current) {
                                n.runOn = current + n.period;
                            }
                            this.queue.rescheduleMin(n.runOn);
                            break;
                        }
                        case 3: {
                            Thread th;
                            Executor e = threadPool.getExecutor();
                            if (e != null) {
                                e.setPriorityI(n.priority);
                                e.setRunnable(n, n.getEName(), threadPool, n.acc);
                            } else {
                                th = new Thread((Runnable)n, n.getEName());
                                th.setPriority(n.priority);
                                th.start();
                            }
                            if (n.runOn < current) {
                                n.runOn = current + n.period;
                            }
                            this.queue.rescheduleMin(n.runOn);
                        }
                    }
                    continue;
                }
            }
            object = this.sync;
            synchronized (object) {
                long tmpWait;
                if (n != null && (tmpWait = n.runOn - System.currentTimeMillis()) > 0L) {
                    try {
                        this.sync.wait(tmpWait);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    TimerQueueNode tmp = null;
                    TimerQueue timerQueue = this.queue;
                    synchronized (timerQueue) {
                        tmp = this.queue.getMin();
                        if (tmp != n) {
                            n = tmp;
                        }
                    }
                }
            }
        }
        nodePool.clear();
        nodePool = null;
        nodes.clear();
        nodes = null;
        this.queue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminated = true;
        Object object = this.sync;
        synchronized (object) {
            this.sync.notify();
        }
        try {
            this.th.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(TimerListener listener, int priority, int timerType, long periodMilis, int event, String name, AccessControlContext acc) {
        TimerQueueNode nx;
        if (this.terminated || nodePool == null) {
            throw new RuntimeException("This Instance is a ZOMBIE!!!" + this.terminated + " " + nodePool);
        }
        TimerQueueNode n = (TimerQueueNode)nodePool.getObject();
        n.setEvent(listener, priority, timerType, System.currentTimeMillis() + periodMilis, periodMilis, event, name, acc);
        TimerQueueNode tmp = (TimerQueueNode)nodes.remove(n);
        if (tmp != null) {
            TimerQueue timerQueue = this.queue;
            synchronized (timerQueue) {
                this.queue.removeTimerNode(tmp);
            }
            tmp.returnInPool();
        }
        nodes.put(n, n);
        Object object = this.queue;
        synchronized (object) {
            this.queue.add(n);
            nx = this.queue.getMin();
        }
        if (nx == n) {
            object = this.sync;
            synchronized (object) {
                this.sync.notifyAll();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addNotifyListener(TimerListener listener, int priority, int timerType, long periodMilis, int event, String name) {
        if (timerType < 0 || timerType > 3) {
            throw new IllegalArgumentException("Invalid Timer Type");
        }
        if (listener == null) throw new IllegalArgumentException("The timer listener is null");
        if (priority < 1 || priority > 10) throw new IllegalArgumentException("Priority must be between Thread.MIN_PRIORITY and Thread.MAX_PRIORITY!");
        if (periodMilis <= 0L) {
            throw new IllegalArgumentException("Time period must be positive!");
        }
        AccessControlContext acc = Log.security() ? AccessController.getContext() : null;
        this.put(listener, priority, timerType, periodMilis, event, name, acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TimerListener listener, int event) {
        TimerQueueNode rmTmp = (TimerQueueNode)nodePool.getObject();
        rmTmp.setEvent(listener, 0, 0, 0L, 0L, event, null, null);
        TimerQueueNode old = (TimerQueueNode)nodes.remove(rmTmp);
        if (old != null) {
            TimerQueue timerQueue = this.queue;
            synchronized (timerQueue) {
                this.queue.removeTimerNode(old);
            }
            old.returnInPool();
        }
        rmTmp.returnInPool();
    }

    public Thread getOne() throws Exception {
        if (this.action == null) {
            this.action = new PrivilegedActionImpl();
        }
        this.action.set(this);
        return (Thread)AccessController.doPrivileged(this.action);
    }

    private class PrivilegedActionImpl
    implements PrivilegedAction {
        private Runnable runnable = null;
        private boolean locked = false;
        private boolean waiting = false;

        PrivilegedActionImpl() {
        }

        public synchronized void set(Runnable runnable) {
            while (this.locked) {
                this.waiting = true;
                try {
                    this.wait();
                }
                catch (Exception exception) {}
                this.waiting = false;
            }
            this.locked = true;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            Runnable runnableLocal = null;
            PrivilegedActionImpl privilegedActionImpl = this;
            synchronized (privilegedActionImpl) {
                runnableLocal = this.runnable;
                this.runnable = null;
                this.locked = false;
                if (this.waiting) {
                    this.notifyAll();
                }
            }
            return new Thread(runnableLocal, "[Timer] - Main Queue Handler");
        }
    }
}

