/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.parameters.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.parameters.ParametersUtils;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.ParametersPackage;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.StateParams;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.parameters.validation.AbstractParametersValidator;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ParametersValidator
extends AbstractParametersValidator {
    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getFileImport_ImportURI());
        }
    }

    @Check
    public void checkDuplicateEvents(Parameters m) {
        ArrayList<String> events = new ArrayList<String>();
        EList<TriggerParams> _triggerParams = m.getTriggerParams();
        for (TriggerParams triggerParams : _triggerParams) {
            boolean _contains = events.contains(triggerParams.getEvent().getName());
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("'Duplicate trigger \"");
                String _name = triggerParams.getEvent().getName();
                _builder.append(_name);
                _builder.append("\"");
                this.error(_builder.toString(), triggerParams, (EStructuralFeature)ParametersPackage.Literals.TRIGGER_PARAMS__EVENT);
            }
            events.add(triggerParams.getEvent().getName());
        }
    }

    @Check
    public void checkEvents(Parameters m) {
        if (m.getInterface() == null || m.getInterface().getName() == null) {
            return;
        }
        Interface itf = m.getInterface();
        EVariableCollection variables = new EVariableCollection();
        EList<Variable> _vars = m.getVars();
        for (Variable variable : _vars) {
            variables.add(variable.getName(), null);
        }
        EList<Action> _initActions = m.getInitActions();
        for (Action a : _initActions) {
            AssignmentAction action = (AssignmentAction)a;
            variables.put(action.getAssignment().getName(), EVariable.fromExpression((Expression)action.getExp(), null));
        }
        Map<InterfaceEvent, Set<String>> transitionStates = ParametersUtils.getTransitionStates(itf);
        Set<Map.Entry<InterfaceEvent, Set<String>>> _entrySet = transitionStates.entrySet();
        for (final Map.Entry<InterfaceEvent, Set<String>> entry : _entrySet) {
            Functions.Function1<TriggerParams, Boolean> _function = new Functions.Function1<TriggerParams, Boolean>(){

                public Boolean apply(TriggerParams t) {
                    return t.getEvent().getName().equals(((InterfaceEvent)entry.getKey()).getName());
                }
            };
            final TriggerParams trigger = (TriggerParams)IterableExtensions.findFirst(m.getTriggerParams(), (Functions.Function1)_function);
            Functions.Function1<Parameter, Boolean> _function_1 = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter p) {
                    DIRECTION _direction = p.getDirection();
                    return !com.google.common.base.Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                }
            };
            Iterable expectedParameters = IterableExtensions.filter((Iterable)entry.getKey().getParameters(), (Functions.Function1)_function_1);
            if (trigger == null) {
                boolean _not;
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)expectedParameters);
                boolean bl = _not = !_isEmpty;
                if (!_not) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Trigger \"");
                String _name = entry.getKey().getName();
                _builder.append(_name);
                _builder.append("\" is missing");
                this.error(_builder.toString(), (EObject)m, null);
                continue;
            }
            Functions.Function1<StateParams, String> _function_2 = new Functions.Function1<StateParams, String>(){

                public String apply(StateParams d) {
                    return d.getState().getName();
                }
            };
            final List states = ListExtensions.map(trigger.getStateParams(), (Functions.Function1)_function_2);
            Functions.Function1<String, Boolean> _function_3 = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String s) {
                    boolean _contains = states.contains(s);
                    return !_contains;
                }
            };
            Consumer<String> _function_4 = new Consumer<String>(){

                @Override
                public void accept(String s) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Trigger \"");
                    String _name = ((InterfaceEvent)entry.getKey()).getName();
                    _builder.append(_name);
                    _builder.append("\" is missing parameters for state \"");
                    _builder.append(s);
                    _builder.append("\"");
                    ParametersValidator.this.error(_builder.toString(), trigger, (EStructuralFeature)ParametersPackage.Literals.TRIGGER_PARAMS__EVENT);
                }
            };
            IterableExtensions.filter((Iterable)entry.getValue(), (Functions.Function1)_function_3).forEach(_function_4);
            EList<StateParams> _stateParams = trigger.getStateParams();
            for (StateParams stateParams : _stateParams) {
                EList<Params> _params = stateParams.getParams();
                for (Params paramSet : _params) {
                    int _length_1;
                    boolean _greaterThan;
                    int _length = ((Object[])Conversions.unwrapArray(paramSet.getValue(), Object.class)).length;
                    boolean bl = _greaterThan = _length > (_length_1 = ((Object[])Conversions.unwrapArray((Object)expectedParameters, Object.class)).length);
                    if (_greaterThan) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("Too many parameters provided");
                        this.error(_builder_1.toString(), paramSet, (EStructuralFeature)ParametersPackage.Literals.STATE_PARAMS__PARAMS);
                    }
                    int index = 0;
                    for (Parameter expectedParameter : expectedParameters) {
                        Expression _xifexpression = null;
                        int _length_2 = ((Object[])Conversions.unwrapArray(paramSet.getValue(), Object.class)).length;
                        boolean _greaterThan_1 = _length_2 > index;
                        _xifexpression = _greaterThan_1 ? (Expression)paramSet.getValue().get(index) : null;
                        Expression actualParameter = _xifexpression;
                        if (actualParameter == null) {
                            StringConcatenation _builder_2 = new StringConcatenation();
                            _builder_2.append("No value provided for parameter \"");
                            String _name_1 = expectedParameter.getName();
                            _builder_2.append(_name_1);
                            _builder_2.append("\"");
                            this.error(_builder_2.toString(), paramSet, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE);
                        }
                        ++index;
                        try {
                            EVariable actualType = EVariable.fromExpression((Expression)actualParameter, (EVariableCollection)variables);
                            EVariable expectedType = EVariable.fromType((Object)expectedParameter.getType().getType());
                            if (Objects.equals(actualType.type, expectedType.type) && Objects.equals(actualType.subtype, expectedType.subtype)) continue;
                            String _xifexpression_1 = null;
                            if (expectedType.subtype != null) {
                                StringConcatenation _builder_3 = new StringConcatenation();
                                String _string = expectedType.type.toString();
                                _builder_3.append(_string);
                                _builder_3.append(".");
                                _builder_3.append(expectedType.subtype);
                                _xifexpression_1 = _builder_3.toString();
                            } else {
                                _xifexpression_1 = expectedType.type.toString();
                            }
                            String expectedStr = _xifexpression_1;
                            String _xifexpression_2 = null;
                            if (actualType.subtype != null) {
                                StringConcatenation _builder_4 = new StringConcatenation();
                                String _string_1 = actualType.type.toString();
                                _builder_4.append(_string_1);
                                _builder_4.append(".");
                                _builder_4.append(actualType.subtype);
                                _xifexpression_2 = _builder_4.toString();
                            } else {
                                _xifexpression_2 = actualType.type.toString();
                            }
                            String actualStr = _xifexpression_2;
                            StringConcatenation _builder_5 = new StringConcatenation();
                            _builder_5.append("Type mismatch for parameter \"");
                            String _name_2 = expectedParameter.getName();
                            _builder_5.append(_name_2);
                            _builder_5.append("\", expected \"");
                            _builder_5.append(expectedStr);
                            _builder_5.append("\" got \"");
                            _builder_5.append(actualStr);
                            _builder_5.append("\"");
                            this.error(_builder_5.toString(), paramSet, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Exception) {
                                StringConcatenation _builder_6 = new StringConcatenation();
                                _builder_6.append("Parameter \"");
                                String _name_3 = expectedParameter.getName();
                                _builder_6.append(_name_3);
                                _builder_6.append("\" is undefined");
                                this.error(_builder_6.toString(), paramSet, (EStructuralFeature)ParametersPackage.Literals.PARAMS__VALUE);
                                continue;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                }
            }
        }
    }
}

