/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;

public final class DatetimeHelper {
    private static final DateTimeFormatter datetimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffset("+HHMMss", "Z").optionalEnd().optionalStart().appendOffset("+HH:MM:ss", "").optionalEnd().toFormatter();
    private static final DateTimeFormatter yearMonthFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR).toFormatter().withResolverStyle(ResolverStyle.LENIENT);
    private static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(datetimeFormatter).appendOptional(DateTimeFormatter.ISO_LOCAL_DATE).appendOptional(yearMonthFormatter).toFormatter();

    private DatetimeHelper() {
    }

    public static String format(Instant d) {
        return datetimeFormatter.format(d.atZone(ZoneOffset.UTC));
    }

    public static OffsetDateTime parse(String d) {
        TemporalAccessor t = formatter.parse(d);
        if (!t.isSupported(ChronoField.HOUR_OF_DAY)) {
            if (!t.isSupported(ChronoField.DAY_OF_MONTH)) {
                return OffsetDateTime.of(LocalDate.of(Year.from(t).getValue(), Month.from(t), 1), LocalTime.MIDNIGHT, ZoneOffset.UTC);
            }
            return OffsetDateTime.of(LocalDate.from(t), LocalTime.MIDNIGHT, ZoneOffset.UTC);
        }
        if (!t.isSupported(ChronoField.MONTH_OF_YEAR)) {
            return OffsetDateTime.of(LocalDate.ofEpochDay(0L), LocalTime.from(t), ZoneOffset.UTC);
        }
        return OffsetDateTime.from(t);
    }

    public static OffsetDateTime datetime(String d) {
        return DatetimeHelper.parse(d);
    }

    public static OffsetDateTime datetime() {
        return OffsetDateTime.now();
    }
}

