/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.DArrCounts;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.Util;

public class DblArrayCountHashMap {
    protected static final Log LOG = LogFactory.getLog((String)DoubleCountHashMap.class.getName());
    protected static final int RESIZE_FACTOR = 2;
    protected static final float LOAD_FACTOR = 0.8f;
    public static int hashMissCount = 0;
    protected int _size = -1;
    private Bucket[] _data = null;

    public DblArrayCountHashMap(int init_capacity) {
        this._data = new Bucket[Util.getPow2(init_capacity)];
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    private void appendValue(DArrCounts ent) {
        int hash = ent.key.hashCode();
        int ix = DblArrayCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        if (l == null) {
            this._data[ix] = new Bucket(ent);
        } else {
            while (l != null) {
                l = l.n;
            }
            Bucket ob = this._data[ix];
            this._data[ix] = new Bucket(ent);
            this._data[ix].n = ob;
        }
        ++this._size;
    }

    public int increment(DblArray key) {
        int hash = key.hashCode();
        int ix = DblArrayCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        while (l != null && !l.v.key.equals(key)) {
            ++hashMissCount;
            l = l.n;
        }
        if (l == null) {
            return this.addNewBucket(ix, key);
        }
        ++l.v.count;
        return l.v.id;
    }

    private synchronized int addNewBucket(int ix, DblArray key) {
        Bucket ob = this._data[ix];
        this._data[ix] = new Bucket(new DArrCounts(new DblArray(key), this._size));
        this._data[ix].n = ob;
        int id = this._size++;
        if ((float)this._size >= 0.8f * (float)this._data.length) {
            this.resize();
        }
        return id;
    }

    public int get(DblArray key) {
        int hash = key.hashCode();
        int ix = DblArrayCountHashMap.indexFor(hash, this._data.length);
        Bucket l = this._data[ix];
        while (!l.v.key.equals(key)) {
            l = l.n;
        }
        return l.v.count;
    }

    public ArrayList<DArrCounts> extractValues() {
        ArrayList<DArrCounts> ret = new ArrayList<DArrCounts>(this._size);
        for (Bucket e : this._data) {
            while (e != null) {
                ret.add(e.v);
                e = e.n;
            }
        }
        return ret;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            return;
        }
        Bucket[] olddata = this._data;
        this._data = new Bucket[this._data.length * 2];
        this._size = 0;
        for (Bucket e : olddata) {
            while (e != null) {
                this.appendValue(e.v);
                e = e.n;
            }
        }
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + this.hashCode());
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == null) continue;
            sb.append(", " + this._data[i]);
        }
        return sb.toString();
    }

    public void reset(int size) {
        int p2 = Util.getPow2(size);
        if (this._data.length > 2 * p2) {
            this._data = new Bucket[p2];
        } else {
            Arrays.fill(this._data, null);
        }
        this._size = 0;
    }

    protected class Bucket {
        protected DArrCounts v;
        protected Bucket n = null;

        protected Bucket(DArrCounts v) {
            this.v = v;
        }

        public String toString() {
            if (this.n == null) {
                return this.v.toString();
            }
            return this.v.toString() + "->" + this.n.toString();
        }
    }
}

