/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.servlets.resolver.internal.ServletWrapperUtil;
import org.apache.sling.servlets.resolver.internal.resource.ServletResource;

public class ScriptResource
extends AbstractResource {
    private AtomicReference<Resource> sharedResource = new AtomicReference();
    private final ResourceResolver sharedResourceResolver;
    private final Supplier<ResourceResolver> perThreadResourceResolver;
    private final String path;

    public ScriptResource(Resource resource, Supplier<ResourceResolver> perThreadScriptResolver, ResourceResolver sharedResourceResolver) {
        this.path = resource.getPath();
        this.sharedResourceResolver = sharedResourceResolver;
        this.perThreadResourceResolver = perThreadScriptResolver;
    }

    private Resource getActiveResource() {
        ResourceResolver perThreadResolver = this.perThreadResourceResolver.get();
        if (perThreadResolver != null && perThreadResolver.isLive()) {
            return perThreadResolver.getResource(this.path);
        }
        Resource resource = this.sharedResource.get();
        if (resource == null) {
            resource = this.sharedResourceResolver.getResource(this.path);
            this.sharedResource.set(resource);
        }
        return resource;
    }

    public String getResourceType() {
        return this.getActiveResource().getResourceType();
    }

    public String getResourceSuperType() {
        return this.getActiveResource().getResourceSuperType();
    }

    public ResourceResolver getResourceResolver() {
        return this.getActiveResource().getResourceResolver();
    }

    public <T> T adaptTo(Class<T> type) {
        SlingScript s;
        if (type == Servlet.class) {
            Resource activeResource = this.getActiveResource();
            while (activeResource instanceof ResourceWrapper) {
                activeResource = ((ResourceWrapper)activeResource).getResource();
            }
            if (!(activeResource instanceof ServletResource)) {
                Servlet s2 = (Servlet)super.adaptTo(type);
                if (s2 != null) {
                    return (T)s2;
                }
                jakarta.servlet.Servlet sj = (jakarta.servlet.Servlet)super.adaptTo(jakarta.servlet.Servlet.class);
                if (sj != null) {
                    return (T)ServletWrapperUtil.toJavaxServlet(sj);
                }
            }
        } else if (type == jakarta.servlet.Servlet.class) {
            Resource activeResource = this.getActiveResource();
            while (activeResource instanceof ResourceWrapper) {
                activeResource = ((ResourceWrapper)activeResource).getResource();
            }
            if (!(activeResource instanceof ServletResource)) {
                jakarta.servlet.Servlet s3 = (jakarta.servlet.Servlet)super.adaptTo(type);
                if (s3 != null) {
                    return (T)s3;
                }
                Servlet sx = (Servlet)super.adaptTo(Servlet.class);
                if (sx != null) {
                    return (T)ServletWrapperUtil.toJakartaServlet(sx);
                }
            }
        } else if (type == SlingScript.class) {
            SlingScript s4 = (SlingScript)super.adaptTo(type);
            if (s4 != null) {
                return (T)s4;
            }
        } else if (type == SlingScript.class && (s = (SlingScript)super.adaptTo(type)) != null) {
            return (T)s;
        }
        return (T)this.getActiveResource().adaptTo(type);
    }

    public String getPath() {
        return this.path;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.getActiveResource().getResourceMetadata();
    }

    public String getName() {
        return ResourceUtil.getName((String)this.path);
    }

    public Resource getParent() {
        return this.getActiveResource().getParent();
    }

    public Resource getChild(String relPath) {
        return this.getActiveResource().getChild(relPath);
    }

    public Iterator<Resource> listChildren() {
        return this.getActiveResource().listChildren();
    }

    public Iterable<Resource> getChildren() {
        return this.getActiveResource().getChildren();
    }

    public boolean isResourceType(String resourceType) {
        return this.getActiveResource().isResourceType(resourceType);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", superType=" + this.getResourceSuperType() + ", path=" + this.getPath();
    }
}

