/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.AbstractArtifactHandler;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.util.EffectiveNodeType;
import org.jetbrains.annotations.NotNull;

public class FolderArtifactHandler
extends AbstractArtifactHandler {
    private boolean overwritePrimaryTypesOfFolders = true;
    private static final List<String> DISALLOWED_PRIMARY_NODE_TYPE_NAMES = Arrays.asList("nt:base", "nt:hierarchyNode");
    private String nodeType = "nt:folder";

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setOverwritePrimaryTypesOfFolders(boolean overwritePrimaryTypesOfFolders) {
        this.overwritePrimaryTypesOfFolders = overwritePrimaryTypesOfFolders;
    }

    private Node createIntermediateNode(Node parent, String intermediateNodeName) throws RepositoryException {
        Optional<String> defaultPrimaryChildNodeType = EffectiveNodeType.ofNode(parent).getDefaultPrimaryChildNodeTypeName(parent, intermediateNodeName);
        Node node = defaultPrimaryChildNodeType.isPresent() && !DISALLOWED_PRIMARY_NODE_TYPE_NAMES.contains(defaultPrimaryChildNodeType.get()) ? parent.addNode(intermediateNodeName) : parent.addNode(intermediateNodeName, this.nodeType);
        return node;
    }

    @Override
    public ImportInfoImpl accept(@NotNull ImportOptions options, boolean isStrictByDefault, WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact dir = artifacts.getDirectory();
        if (dir == null || artifacts.size() != 1) {
            return null;
        }
        ImportInfoImpl info = new ImportInfoImpl();
        if (dir.getRelativePath().length() == 0) {
            return info;
        }
        if (!parent.hasNode(dir.getRelativePath())) {
            Node node = wspFilter.contains(parent.getPath() + "/" + dir.getRelativePath()) ? parent.addNode(dir.getRelativePath(), this.nodeType) : this.createIntermediateNode(parent, dir.getRelativePath());
            info.onCreated(node.getPath());
        } else {
            HashSet<String> hints = new HashSet<String>();
            String rootPath = parent.getPath();
            if (!rootPath.equals("/")) {
                rootPath = rootPath + "/";
            }
            for (Artifact a : artifacts.values(ArtifactType.HINT)) {
                hints.add(rootPath + a.getRelativePath());
            }
            Node node = parent.getNode(dir.getRelativePath());
            if (this.overwritePrimaryTypesOfFolders && wspFilter.contains(node.getPath()) && wspFilter.getImportMode(node.getPath()) == ImportMode.REPLACE && !this.nodeType.equals(node.getPrimaryNodeType().getName())) {
                this.modifyPrimaryType(node, info);
            }
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                String path = child.getPath();
                if (!wspFilter.contains(path) || wspFilter.getImportMode(path) != ImportMode.REPLACE) continue;
                if (!hints.contains(path)) {
                    if (this.getAclManagement().isACLNode(child)) {
                        if (this.acHandling != AccessControlHandling.OVERWRITE && this.acHandling != AccessControlHandling.CLEAR) continue;
                        info.onDeleted(path);
                        this.getAclManagement().clearACL(node);
                        continue;
                    }
                    info.onDeleted(path);
                    child.remove();
                    continue;
                }
                if (this.acHandling != AccessControlHandling.CLEAR || !this.getAclManagement().isACLNode(child)) continue;
                info.onDeleted(path);
                this.getAclManagement().clearACL(node);
            }
        }
        return info;
    }

    private void modifyPrimaryType(Node node, ImportInfoImpl info) throws RepositoryException {
        this.ensureCheckedOut(node, info);
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            if (property.getDefinition().isProtected()) continue;
            property.remove();
        }
        node.setPrimaryType(this.nodeType);
        info.onModified(node.getPath());
    }

    private void ensureCheckedOut(Node node, ImportInfoImpl info) throws RepositoryException {
        boolean isCheckedOut;
        boolean bl = isCheckedOut = !node.isNodeType("mix:versionable") || node.isCheckedOut();
        if (!isCheckedOut) {
            info.registerToVersion(node.getPath());
            try {
                node.checkout();
            }
            catch (RepositoryException e) {
                ImportInfoImpl.log.warn("error while checkout node (ignored)", (Throwable)e);
            }
        }
    }
}

