/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.ui.web.controller;

import com.google.common.base.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobExecutionTypeStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRegisterStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRunningStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskResultStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskRunningStatistics;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.FacadeService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.state.failover.FailoverTaskInfo;
import org.apache.shardingsphere.elasticjob.cloud.ui.service.statistics.StatisticManager;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.controller.search.JobEventRdbSearch;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.response.ResponseResult;
import org.apache.shardingsphere.elasticjob.cloud.ui.web.response.ResponseResultUtil;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/job"})
public final class CloudJobController {
    private static final Logger log = LoggerFactory.getLogger(CloudJobController.class);
    @Autowired
    private JobEventRdbSearch jobEventRdbSearch;
    @Autowired
    private ProducerManager producerManager;
    @Autowired
    private CloudJobConfigurationService jobConfigService;
    @Autowired
    private FacadeService facadeService;
    @Autowired
    private StatisticManager statisticManager;

    @PostMapping(value={"/register"})
    public ResponseResult<Boolean> register(@RequestBody CloudJobConfigurationPOJO cloudJobConfig) {
        this.producerManager.register(cloudJobConfig);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PutMapping(value={"/update"})
    public ResponseResult<Boolean> update(@RequestBody CloudJobConfigurationPOJO cloudJobConfig) {
        this.producerManager.update(cloudJobConfig);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @DeleteMapping(value={"/{jobName}/deregister"})
    public ResponseResult<Boolean> deregister(@PathVariable String jobName) {
        this.producerManager.deregister(jobName);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @GetMapping(value={"/{jobName}/disable"})
    public ResponseResult<Boolean> isDisabled(@PathVariable(value="jobName") String jobName) {
        boolean result = this.facadeService.isJobDisabled(jobName);
        return ResponseResultUtil.build(result);
    }

    @PostMapping(value={"/{jobName}/enable"})
    public ResponseResult<Boolean> enable(@PathVariable(value="jobName") String jobName) {
        Optional<CloudJobConfigurationPOJO> configOptional = this.jobConfigService.load(jobName);
        if (configOptional.isPresent()) {
            this.facadeService.enableJob(jobName);
        }
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/{jobName}/disable"})
    public ResponseResult<Boolean> disable(@PathVariable(value="jobName") String jobName) {
        if (this.jobConfigService.load(jobName).isPresent()) {
            this.facadeService.disableJob(jobName);
        }
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @PostMapping(value={"/trigger"})
    public ResponseResult<Boolean> trigger(@RequestBody String jobName) {
        Optional<CloudJobConfigurationPOJO> config = this.jobConfigService.load(jobName);
        if (config.isPresent() && CloudJobExecutionType.DAEMON == config.get().getJobExecutionType()) {
            throw new JobSystemException("Daemon job '%s' cannot support trigger.", new Object[]{jobName});
        }
        this.facadeService.addTransient(jobName);
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @GetMapping(value={"/jobs/{jobName}"})
    public ResponseResult<CloudJobConfigurationPOJO> detail(@PathVariable(value="jobName") String jobName) {
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.jobConfigService.load(jobName);
        return ResponseResultUtil.build(cloudJobConfig.orElse(null));
    }

    @GetMapping(value={"/jobs"})
    public ResponseResult<Collection<CloudJobConfigurationPOJO>> findAllJobs() {
        return ResponseResultUtil.build(this.jobConfigService.loadAll());
    }

    @GetMapping(value={"tasks/running"})
    public ResponseResult<Collection<TaskContext>> findAllRunningTasks() {
        LinkedList<TaskContext> result = new LinkedList<TaskContext>();
        for (Set<TaskContext> each : this.facadeService.getAllRunningTasks().values()) {
            result.addAll(each);
        }
        return ResponseResultUtil.build(result);
    }

    @GetMapping(value={"tasks/ready"})
    public ResponseResult<Collection<Map<String, String>>> findAllReadyTasks() {
        Map<String, Integer> readyTasks = this.facadeService.getAllReadyTasks();
        ArrayList result = new ArrayList(readyTasks.size());
        for (Map.Entry<String, Integer> each : readyTasks.entrySet()) {
            HashMap<String, String> oneTask = new HashMap<String, String>(2, 1.0f);
            oneTask.put("jobName", each.getKey());
            oneTask.put("times", String.valueOf(each.getValue()));
            result.add(oneTask);
        }
        return ResponseResultUtil.build(result);
    }

    @GetMapping(value={"tasks/failover"})
    public ResponseResult<Collection<FailoverTaskInfo>> findAllFailoverTasks() {
        LinkedList<FailoverTaskInfo> result = new LinkedList<FailoverTaskInfo>();
        for (Collection<FailoverTaskInfo> each : this.facadeService.getAllFailoverTasks().values()) {
            result.addAll(each);
        }
        return ResponseResultUtil.build(result);
    }

    @PostMapping(value={"/events/executions"})
    public ResponseResult<JobEventRdbSearch.Result<JobExecutionEvent>> findJobExecutionEvents(@RequestParam MultiValueMap<String, String> requestParams) throws ParseException {
        if (!this.isRdbConfigured()) {
            return ResponseResultUtil.build(new JobEventRdbSearch.Result(0, Collections.emptyList()));
        }
        return ResponseResultUtil.build(this.jobEventRdbSearch.findJobExecutionEvents(this.buildCondition(requestParams, new String[]{"jobName", "taskId", "ip", "isSuccess"})));
    }

    @PostMapping(value={"/events/statusTraces"})
    public ResponseResult<JobEventRdbSearch.Result<JobStatusTraceEvent>> findJobStatusTraceEvents(@RequestParam MultiValueMap<String, String> requestParams) throws ParseException {
        if (!this.isRdbConfigured()) {
            return ResponseResultUtil.build(new JobEventRdbSearch.Result(0, Collections.emptyList()));
        }
        return ResponseResultUtil.build(this.jobEventRdbSearch.findJobStatusTraceEvents(this.buildCondition(requestParams, new String[]{"jobName", "taskId", "slaveId", "source", "executionType", "state"})));
    }

    private boolean isRdbConfigured() {
        return this.jobEventRdbSearch.isEnable();
    }

    private JobEventRdbSearch.Condition buildCondition(MultiValueMap<String, String> requestParams, String[] params) throws ParseException {
        int perPage = 10;
        int page = 1;
        if (!Strings.isNullOrEmpty((String)((String)requestParams.getFirst((Object)"per_page")))) {
            perPage = Integer.parseInt((String)requestParams.getFirst((Object)"per_page"));
        }
        if (!Strings.isNullOrEmpty((String)((String)requestParams.getFirst((Object)"page")))) {
            page = Integer.parseInt((String)requestParams.getFirst((Object)"page"));
        }
        String sort = (String)requestParams.getFirst((Object)"sort");
        String order = (String)requestParams.getFirst((Object)"order");
        Date startTime = null;
        Date endTime = null;
        Map<String, Object> fields = this.getQueryParameters(requestParams, params);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!Strings.isNullOrEmpty((String)((String)requestParams.getFirst((Object)"startTime")))) {
            startTime = simpleDateFormat.parse((String)requestParams.getFirst((Object)"startTime"));
        }
        if (!Strings.isNullOrEmpty((String)((String)requestParams.getFirst((Object)"endTime")))) {
            endTime = simpleDateFormat.parse((String)requestParams.getFirst((Object)"endTime"));
        }
        return new JobEventRdbSearch.Condition(perPage, page, sort, order, startTime, endTime, fields);
    }

    private Map<String, Object> getQueryParameters(MultiValueMap<String, String> requestParams, String[] params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String each : params) {
            if (Strings.isNullOrEmpty((String)((String)requestParams.getFirst((Object)each)))) continue;
            result.put(each, requestParams.getFirst((Object)each));
        }
        return result;
    }

    @GetMapping(value={"/statistics/tasks/results"})
    public ResponseResult<List<TaskResultStatistics>> findTaskResultStatistics(@RequestParam(value="since", required=false) String since) {
        if ("last24hours".equals(since)) {
            return ResponseResultUtil.build(this.statisticManager.findTaskResultStatisticsDaily());
        }
        return ResponseResultUtil.build(Collections.emptyList());
    }

    @GetMapping(value={"/statistics/tasks/results/{period}"})
    public ResponseResult<TaskResultStatistics> getTaskResultStatistics(@PathVariable(value="period", required=false) String period) {
        TaskResultStatistics taskResultStatistics;
        switch (period) {
            case "online": {
                taskResultStatistics = this.statisticManager.getTaskResultStatisticsSinceOnline();
                break;
            }
            case "lastWeek": {
                taskResultStatistics = this.statisticManager.getTaskResultStatisticsWeekly();
                break;
            }
            case "lastHour": {
                taskResultStatistics = this.statisticManager.findLatestTaskResultStatistics(StatisticInterval.HOUR);
                break;
            }
            case "lastMinute": {
                taskResultStatistics = this.statisticManager.findLatestTaskResultStatistics(StatisticInterval.MINUTE);
                break;
            }
            default: {
                taskResultStatistics = new TaskResultStatistics(0, 0, StatisticInterval.DAY, new Date());
            }
        }
        return ResponseResultUtil.build(taskResultStatistics);
    }

    @GetMapping(value={"/statistics/tasks/running"})
    public ResponseResult<List<TaskRunningStatistics>> findTaskRunningStatistics(@RequestParam(value="since", required=false) String since) {
        if ("lastWeek".equals(since)) {
            return ResponseResultUtil.build(this.statisticManager.findTaskRunningStatisticsWeekly());
        }
        return ResponseResultUtil.build(Collections.emptyList());
    }

    @GetMapping(value={"/statistics/jobs/executionType"})
    public ResponseResult<JobExecutionTypeStatistics> getJobExecutionTypeStatistics() {
        return ResponseResultUtil.build(this.statisticManager.getJobExecutionTypeStatistics());
    }

    @GetMapping(value={"/statistics/jobs/running"})
    public ResponseResult<List<JobRunningStatistics>> findJobRunningStatistics(@RequestParam(value="since", required=false) String since) {
        if ("lastWeek".equals(since)) {
            return ResponseResultUtil.build(this.statisticManager.findJobRunningStatisticsWeekly());
        }
        return ResponseResultUtil.build(Collections.emptyList());
    }

    @GetMapping(value={"/statistics/jobs/register"})
    public ResponseResult<List<JobRegisterStatistics>> findJobRegisterStatistics() {
        return ResponseResultUtil.build(this.statisticManager.findJobRegisterStatisticsSinceOnline());
    }
}

