/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RetryHandler;
import io.vertx.core.VertxException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ExtensionsFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.stereotype.Component;

@Component
public class DefaultRetryExtensionsFactory
implements ExtensionsFactory {
    private static final Collection<String> ACCEPT_KEYS = Lists.newArrayList((Object[])new String[]{"retryHandler"});
    private static final String RETRY_DEFAULT = "default";
    private static final Collection<String> ACCEPT_VALUES = Lists.newArrayList((Object[])new String[]{"default"});
    private static final Map<Class<? extends Throwable>, List<String>> strictRetriable = ImmutableMap.builder().put(ConnectException.class, Arrays.asList(new String[0])).put(SocketTimeoutException.class, Arrays.asList(new String[0])).put(IOException.class, Arrays.asList("Connection reset by peer")).put(VertxException.class, Arrays.asList("Connection was closed")).put(NoRouteToHostException.class, Arrays.asList(new String[0])).build();

    @Override
    public boolean isSupport(String key, String value) {
        return ACCEPT_KEYS.contains(key) && ACCEPT_VALUES.contains(value);
    }

    @Override
    public RetryHandler createRetryHandler(String retryName, String microservice) {
        return new DefaultLoadBalancerRetryHandler(Configuration.INSTANCE.getRetryOnSame(microservice), Configuration.INSTANCE.getRetryOnNext(microservice), true){

            public boolean isRetriableException(Throwable e, boolean sameServer) {
                boolean retriable = this.isPresentAsCause(e);
                if (!retriable && e instanceof InvocationException && ((InvocationException)e).getStatusCode() == 503) {
                    return true;
                }
                return retriable;
            }

            public boolean isPresentAsCause(Throwable throwableToSearchIn) {
                int infiniteLoopPreventionCounter = 10;
                while (throwableToSearchIn != null && infiniteLoopPreventionCounter > 0) {
                    --infiniteLoopPreventionCounter;
                    for (Map.Entry c : strictRetriable.entrySet()) {
                        Class key = (Class)c.getKey();
                        if (!key.isAssignableFrom(throwableToSearchIn.getClass())) continue;
                        if (c.getValue() == null || ((List)c.getValue()).isEmpty()) {
                            return true;
                        }
                        String msg = throwableToSearchIn.getMessage();
                        for (String val : (List)c.getValue()) {
                            if (!val.equals(msg)) continue;
                            return true;
                        }
                    }
                    throwableToSearchIn = throwableToSearchIn.getCause();
                }
                return false;
            }
        };
    }
}

