/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RequestSizeGatewayFilterFactory
extends AbstractGatewayFilterFactory<RequestSizeConfig> {
    private static String PREFIX = "kMGTPE";
    private static String ERROR = "Request size is larger than permissible limit. Request size is %s where permissible limit is %s";

    public RequestSizeGatewayFilterFactory() {
        super(RequestSizeConfig.class);
    }

    @Override
    public GatewayFilter apply(RequestSizeConfig requestSizeConfig) {
        requestSizeConfig.validate();
        return (exchange, chain) -> {
            Long currentRequestSize;
            ServerHttpRequest request = exchange.getRequest();
            String contentLength = request.getHeaders().getFirst("content-length");
            if (!StringUtils.isEmpty((Object)contentLength) && (currentRequestSize = Long.valueOf(contentLength)) > requestSizeConfig.getMaxSize()) {
                exchange.getResponse().setStatusCode(HttpStatus.PAYLOAD_TOO_LARGE);
                exchange.getResponse().getHeaders().add("errorMessage", RequestSizeGatewayFilterFactory.getErrorMessage(currentRequestSize, requestSizeConfig.getMaxSize()));
                return exchange.getResponse().setComplete();
            }
            return chain.filter(exchange);
        };
    }

    private static String getErrorMessage(Long currentRequestSize, Long maxSize) {
        return String.format(ERROR, RequestSizeGatewayFilterFactory.getReadableByteCount(currentRequestSize), RequestSizeGatewayFilterFactory.getReadableByteCount(maxSize));
    }

    private static String getReadableByteCount(long bytes) {
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = Character.toString(PREFIX.charAt(exp - 1));
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static class RequestSizeConfig {
        private Long maxSize = 5000000L;

        public RequestSizeConfig setMaxSize(Long maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Long getMaxSize() {
            return this.maxSize;
        }

        public void validate() {
            Assert.isTrue((this.maxSize != null && this.maxSize > 0L ? 1 : 0) != 0, (String)"maxSize must be greater than 0");
            Assert.isInstanceOf(Long.class, (Object)this.maxSize, (String)"maxSize must be a number");
        }
    }
}

