/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.servo;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.cloud.netflix.metrics.servo.ServoMetricNaming;

public class ServoMetricReader
implements MetricReader {
    MonitorRegistry monitorRegistry;
    ServoMetricNaming metricNaming;

    public ServoMetricReader(MonitorRegistry monitorRegistry, ServoMetricNaming metricNaming) {
        this.monitorRegistry = monitorRegistry;
        this.metricNaming = metricNaming;
    }

    public Metric<?> findOne(String s) {
        throw new UnsupportedOperationException("cannot construct a tag-based Servo id from a hierarchical name");
    }

    public Iterable<Metric<?>> findAll() {
        ArrayList metrics = new ArrayList();
        for (Monitor monitor : this.monitorRegistry.getRegisteredMonitors()) {
            this.addToMetrics(monitor, metrics);
        }
        return metrics;
    }

    private void addToMetrics(Monitor<?> monitor, Collection<Metric<?>> metrics) {
        if (monitor instanceof CompositeMonitor) {
            for (Monitor nestedMonitor : ((CompositeMonitor)monitor).getMonitors()) {
                this.addToMetrics(nestedMonitor, metrics);
            }
        } else if (monitor.getValue() instanceof Number) {
            metrics.add(new Metric(this.metricNaming.asHierarchicalName(monitor), (Number)monitor.getValue()));
        }
    }

    public long count() {
        long count = 0L;
        for (Monitor monitor : this.monitorRegistry.getRegisteredMonitors()) {
            count += ServoMetricReader.countMetrics(monitor);
        }
        return count;
    }

    private static long countMetrics(Monitor<?> monitor) {
        if (monitor instanceof CompositeMonitor) {
            long count = 0L;
            for (Monitor nestedMonitor : ((CompositeMonitor)monitor).getMonitors()) {
                count += ServoMetricReader.countMetrics(nestedMonitor);
            }
            return count;
        }
        return 1L;
    }
}

