/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;
import org.springframework.util.StringUtils;

public class RemoteHostItem
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public String getFormattedItem(AccessLogParam<RoutingContext> accessLogParam) {
        HttpServerRequest request = accessLogParam.getContextData().request();
        if (null == request) {
            return EMPTY_RESULT;
        }
        SocketAddress remoteAddress = request.remoteAddress();
        if (null == remoteAddress) {
            return EMPTY_RESULT;
        }
        String remoteHost = remoteAddress.host();
        if (StringUtils.isEmpty((Object)remoteHost)) {
            return EMPTY_RESULT;
        }
        return remoteHost;
    }
}

