/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.test.producer;

import org.apache.webbeans.test.AbstractUnitTest;
import org.junit.Assert;
import org.junit.Test;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;

public class StringProducerTest extends AbstractUnitTest
{

    @Test
    public void testNamedProducer()
    {
        startContainer(StringProducer.class);

        final Bean<?> bean = getBeanManager().getBeans(String.class).iterator().next();
        final CreationalContext<?> context = getBeanManager().createCreationalContext(bean);
        final String produced = String.class.cast(getBeanManager().getReference(bean, String.class, context));
        
        Assert.assertEquals("string", produced);
        
        shutDownContainer();       
        
    }

    public static class StringProducer
    {
        @Produces
        public String produces()
        {
            return "string";
        }
    }

}
