/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.catalog.api.DataType;
import org.apache.logging.log4j.catalog.jpa.converter.BooleanToStringConverter;
import org.apache.logging.log4j.catalog.jpa.converter.DataTypeConverter;
import org.apache.logging.log4j.catalog.jpa.model.ConstraintModel;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

@Entity
@Table(name="EVENT_ATTRIBUTE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME"})})
public class AttributeModel
implements Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    private static final long serialVersionUID = -756109102178482698L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="ID", updatable=false, nullable=false)
    private Long id;
    @Column(name="NAME")
    private String name;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CATALOG_ID")
    private String catalogId = "DEFAULT";
    @Column(name="DATATYPE")
    @Convert(converter=DataTypeConverter.class)
    private DataType dataType;
    @Column(name="INDEXED")
    @Convert(converter=BooleanToStringConverter.class)
    private boolean indexed;
    @Column(name="SORTABLE")
    @Convert(converter=BooleanToStringConverter.class)
    private boolean sortable;
    @Column(name="REQUIRED")
    @Convert(converter=BooleanToStringConverter.class)
    private boolean required;
    @Column(name="REQUEST_CONTEXT")
    @Convert(converter=BooleanToStringConverter.class)
    private boolean requestContext;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="attribute_examples", joinColumns={@JoinColumn(name="attribute_id")})
    @Column(name="example")
    private Set<String> examples = new HashSet<String>();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="attribute_aliases", joinColumns={@JoinColumn(name="attribute_id")})
    @Column(name="alias")
    private Set<String> aliases = new HashSet<String>();
    @OneToMany(fetch=FetchType.EAGER, mappedBy="attribute", cascade={CascadeType.ALL})
    private Set<ConstraintModel> constraints;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public Long getId() {
        return this._persistence_get_id();
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getDisplayName() {
        return this._persistence_get_displayName();
    }

    public void setDisplayName(String name) {
        this._persistence_set_displayName(name);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public DataType getDataType() {
        return this._persistence_get_dataType();
    }

    public void setDataType(DataType dataType) {
        this._persistence_set_dataType(dataType);
    }

    public boolean isIndexed() {
        return this._persistence_get_indexed();
    }

    public void setIndexed(boolean indexed) {
        this._persistence_set_indexed(indexed);
    }

    public boolean isSortable() {
        return this._persistence_get_sortable();
    }

    public void setSortable(boolean sortable) {
        this._persistence_set_sortable(sortable);
    }

    public boolean isRequired() {
        return this._persistence_get_required();
    }

    public void setRequired(boolean required) {
        this._persistence_set_required(required);
    }

    public boolean isRequestContext() {
        return this._persistence_get_requestContext();
    }

    public void setRequestContext(boolean isRequestContext) {
        this._persistence_set_requestContext(isRequestContext);
    }

    public Set<String> getExamples() {
        return this._persistence_get_examples();
    }

    public void setExamples(Set<String> examples) {
        this._persistence_set_examples(examples);
    }

    public Set<String> getAliases() {
        return this._persistence_get_aliases();
    }

    public String getCatalogId() {
        return this._persistence_get_catalogId();
    }

    public void setCatalogId(String catalogId) {
        this._persistence_set_catalogId(catalogId);
    }

    public void setAliases(Set<String> aliases) {
        this._persistence_set_aliases(aliases);
    }

    public Set<ConstraintModel> getConstraints() {
        return this._persistence_get_constraints();
    }

    public void setConstraints(Set<ConstraintModel> constraints) {
        if (constraints == null) {
            if (this._persistence_get_constraints() == null) {
                this._persistence_set_constraints(new HashSet());
            }
        } else {
            for (ConstraintModel constraint : constraints) {
                if (constraint.getAttribute() == this) continue;
                constraint.setAttribute(this);
            }
            this._persistence_set_constraints(constraints);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._persistence_get_name()).append((Object)this._persistence_get_catalogId()).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof AttributeModel)) {
            return false;
        }
        AttributeModel other = (AttributeModel)o;
        return new EqualsBuilder().append((Object)this._persistence_get_name(), (Object)other._persistence_get_name()).append((Object)this._persistence_get_catalogId(), (Object)other._persistence_get_catalogId()).isEquals();
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AttributeModel();
    }

    public Object _persistence_get(String string) {
        if (string == "aliases") {
            return this.aliases;
        }
        if (string == "indexed") {
            return this.indexed;
        }
        if (string == "displayName") {
            return this.displayName;
        }
        if (string == "dataType") {
            return this.dataType;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "sortable") {
            return this.sortable;
        }
        if (string == "constraints") {
            return this.constraints;
        }
        if (string == "required") {
            return this.required;
        }
        if (string == "catalogId") {
            return this.catalogId;
        }
        if (string == "requestContext") {
            return this.requestContext;
        }
        if (string == "examples") {
            return this.examples;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "id") {
            return this.id;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "aliases") {
            this.aliases = (Set)object;
            return;
        }
        if (string == "indexed") {
            this.indexed = (Boolean)object;
            return;
        }
        if (string == "displayName") {
            this.displayName = (String)object;
            return;
        }
        if (string == "dataType") {
            this.dataType = (DataType)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "sortable") {
            this.sortable = (Boolean)object;
            return;
        }
        if (string == "constraints") {
            this.constraints = (Set)object;
            return;
        }
        if (string == "required") {
            this.required = (Boolean)object;
            return;
        }
        if (string == "catalogId") {
            this.catalogId = (String)object;
            return;
        }
        if (string == "requestContext") {
            this.requestContext = (Boolean)object;
            return;
        }
        if (string == "examples") {
            this.examples = (Set)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
    }

    public Set _persistence_get_aliases() {
        this._persistence_checkFetched("aliases");
        return this.aliases;
    }

    public void _persistence_set_aliases(Set set) {
        this._persistence_checkFetchedForSet("aliases");
        this.aliases = set;
    }

    public boolean _persistence_get_indexed() {
        this._persistence_checkFetched("indexed");
        return this.indexed;
    }

    public void _persistence_set_indexed(boolean bl) {
        this._persistence_checkFetchedForSet("indexed");
        this.indexed = bl;
    }

    public String _persistence_get_displayName() {
        this._persistence_checkFetched("displayName");
        return this.displayName;
    }

    public void _persistence_set_displayName(String string) {
        this._persistence_checkFetchedForSet("displayName");
        this.displayName = string;
    }

    public DataType _persistence_get_dataType() {
        this._persistence_checkFetched("dataType");
        return this.dataType;
    }

    public void _persistence_set_dataType(DataType dataType) {
        this._persistence_checkFetchedForSet("dataType");
        this.dataType = dataType;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public boolean _persistence_get_sortable() {
        this._persistence_checkFetched("sortable");
        return this.sortable;
    }

    public void _persistence_set_sortable(boolean bl) {
        this._persistence_checkFetchedForSet("sortable");
        this.sortable = bl;
    }

    public Set _persistence_get_constraints() {
        this._persistence_checkFetched("constraints");
        return this.constraints;
    }

    public void _persistence_set_constraints(Set set) {
        this._persistence_checkFetchedForSet("constraints");
        this.constraints = set;
    }

    public boolean _persistence_get_required() {
        this._persistence_checkFetched("required");
        return this.required;
    }

    public void _persistence_set_required(boolean bl) {
        this._persistence_checkFetchedForSet("required");
        this.required = bl;
    }

    public String _persistence_get_catalogId() {
        this._persistence_checkFetched("catalogId");
        return this.catalogId;
    }

    public void _persistence_set_catalogId(String string) {
        this._persistence_checkFetchedForSet("catalogId");
        this.catalogId = string;
    }

    public boolean _persistence_get_requestContext() {
        this._persistence_checkFetched("requestContext");
        return this.requestContext;
    }

    public void _persistence_set_requestContext(boolean bl) {
        this._persistence_checkFetchedForSet("requestContext");
        this.requestContext = bl;
    }

    public Set _persistence_get_examples() {
        this._persistence_checkFetched("examples");
        return this.examples;
    }

    public void _persistence_set_examples(Set set) {
        this._persistence_checkFetchedForSet("examples");
        this.examples = set;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this.id = l;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

