/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordQualityRequirementValidationResult;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordValidationDetailsResponseType;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordQualityRequirement;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordValidationDetailsResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String PASSWORD_VALIDATION_DETAILS_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.41";
    private static final byte TYPE_MISSING_CURRENT_PASSWORD = -125;
    private static final byte TYPE_MUST_CHANGE_PW = -124;
    private static final byte TYPE_SECONDS_UNTIL_EXPIRATION = -123;
    @NotNull
    private static final String JSON_FIELD_ADDITIONAL_INFORMATION = "additional-information";
    @NotNull
    private static final String JSON_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES = "client-side-validation-properties";
    @NotNull
    private static final String JSON_FIELD_CLIENT_SIDE_VALIDATION_TYPE = "client-side-validation-type";
    @NotNull
    private static final String JSON_FIELD_DESCRIPTION = "description";
    @NotNull
    private static final String JSON_FIELD_MISSING_CURRENT_PASSWORD = "missing-current-password";
    @NotNull
    private static final String JSON_FIELD_MUST_CHANGE_PASSWORD = "must-change-password";
    @NotNull
    private static final String JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT = "password-quality-requirement";
    @NotNull
    private static final String JSON_FIELD_PROPERTY_NAME = "name";
    @NotNull
    private static final String JSON_FIELD_PROPERTY_VALUE = "value";
    @NotNull
    private static final String JSON_FIELD_REQUIREMENT_SATISFIED = "requirement-satisfied";
    @NotNull
    private static final String JSON_FIELD_RESPONSE_TYPE = "response-type";
    @NotNull
    private static final String JSON_FIELD_SECONDS_UNTIL_EXPIRATION = "seconds-until-expiration";
    @NotNull
    private static final String JSON_FIELD_VALIDATION_DETAILS = "validation-details";
    @NotNull
    private static final String JSON_RESPONSE_TYPE_MULTIPLE_PASSWORDS_PROVIDED = "multiple-passwords-provided";
    @NotNull
    private static final String JSON_RESPONSE_TYPE_NO_PASSWORD_PROVIDED = "no-password-provided";
    @NotNull
    private static final String JSON_RESPONSE_TYPE_NO_VALIDATION_ATTEMPTED = "no-validation-attempted";
    @NotNull
    private static final String JSON_RESPONSE_TYPE_VALIDATION_PERFORMED = "validation-performed";
    private static final long serialVersionUID = -2205640814914704074L;
    private final boolean missingCurrentPassword;
    private final boolean mustChangePassword;
    @Nullable
    private final Integer secondsUntilExpiration;
    @NotNull
    private final List<PasswordQualityRequirementValidationResult> validationResults;
    @NotNull
    private final PasswordValidationDetailsResponseType responseType;

    PasswordValidationDetailsResponseControl() {
        this.responseType = null;
        this.validationResults = null;
        this.missingCurrentPassword = true;
        this.mustChangePassword = true;
        this.secondsUntilExpiration = null;
    }

    public PasswordValidationDetailsResponseControl(@NotNull PasswordValidationDetailsResponseType responseType, @Nullable Collection<PasswordQualityRequirementValidationResult> validationResults, boolean missingCurrentPassword, boolean mustChangePassword, @Nullable Integer secondsUntilExpiration) {
        super(PASSWORD_VALIDATION_DETAILS_RESPONSE_OID, false, PasswordValidationDetailsResponseControl.encodeValue(responseType, validationResults, missingCurrentPassword, mustChangePassword, secondsUntilExpiration));
        this.responseType = responseType;
        this.missingCurrentPassword = missingCurrentPassword;
        this.mustChangePassword = mustChangePassword;
        this.secondsUntilExpiration = secondsUntilExpiration;
        this.validationResults = validationResults == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordQualityRequirementValidationResult>(validationResults));
    }

    public PasswordValidationDetailsResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.responseType = PasswordValidationDetailsResponseType.forBERType(elements[0].getType());
            if (this.responseType == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_INVALID_RESPONSE_TYPE.get(StaticUtils.toHex(elements[0].getType())));
            }
            if (this.responseType == PasswordValidationDetailsResponseType.VALIDATION_DETAILS) {
                ASN1Element[] resultElements = ASN1Sequence.decodeAsSequence(elements[0]).elements();
                ArrayList<PasswordQualityRequirementValidationResult> resultList = new ArrayList<PasswordQualityRequirementValidationResult>(resultElements.length);
                for (ASN1Element e : resultElements) {
                    resultList.add(PasswordQualityRequirementValidationResult.decode(e));
                }
                this.validationResults = Collections.unmodifiableList(resultList);
            } else {
                this.validationResults = Collections.emptyList();
            }
            boolean missingCurrent = false;
            boolean mustChange = false;
            Integer secondsRemaining = null;
            block9: for (int i = 1; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -125: {
                        missingCurrent = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block9;
                    }
                    case -124: {
                        mustChange = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block9;
                    }
                    case -123: {
                        secondsRemaining = ASN1Integer.decodeAsInteger(elements[i]).intValue();
                        continue block9;
                    }
                }
            }
            this.missingCurrentPassword = missingCurrent;
            this.mustChangePassword = mustChange;
            this.secondsUntilExpiration = secondsRemaining;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull PasswordValidationDetailsResponseType responseType, @Nullable Collection<PasswordQualityRequirementValidationResult> validationResults, boolean missingCurrentPassword, boolean mustChangePassword, @Nullable Integer secondsUntilExpiration) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        switch (responseType) {
            case VALIDATION_DETAILS: {
                if (validationResults == null) {
                    elements.add(new ASN1Sequence(responseType.getBERType()));
                    break;
                }
                ArrayList<ASN1Element> resultElements = new ArrayList<ASN1Element>(validationResults.size());
                for (PasswordQualityRequirementValidationResult r : validationResults) {
                    resultElements.add(r.encode());
                }
                elements.add(new ASN1Sequence(responseType.getBERType(), resultElements));
                break;
            }
            case NO_PASSWORD_PROVIDED: 
            case MULTIPLE_PASSWORDS_PROVIDED: 
            case NO_VALIDATION_ATTEMPTED: {
                elements.add(new ASN1Null(responseType.getBERType()));
            }
        }
        if (missingCurrentPassword) {
            elements.add(new ASN1Boolean(-125, missingCurrentPassword));
        }
        if (mustChangePassword) {
            elements.add(new ASN1Boolean(-124, mustChangePassword));
        }
        if (secondsUntilExpiration != null) {
            elements.add(new ASN1Integer(-123, secondsUntilExpiration));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public PasswordValidationDetailsResponseType getResponseType() {
        return this.responseType;
    }

    @NotNull
    public List<PasswordQualityRequirementValidationResult> getValidationResults() {
        return this.validationResults;
    }

    public boolean missingCurrentPassword() {
        return this.missingCurrentPassword;
    }

    public boolean mustChangePassword() {
        return this.mustChangePassword;
    }

    @Nullable
    public Integer getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    @Override
    @NotNull
    public PasswordValidationDetailsResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new PasswordValidationDetailsResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static PasswordValidationDetailsResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(PASSWORD_VALIDATION_DETAILS_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof PasswordValidationDetailsResponseControl) {
            return (PasswordValidationDetailsResponseControl)c;
        }
        return new PasswordValidationDetailsResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public static PasswordValidationDetailsResponseControl get(@NotNull LDAPException exception) throws LDAPException {
        return PasswordValidationDetailsResponseControl.get(exception.toLDAPResult());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PW_VALIDATION_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        switch (this.responseType) {
            case VALIDATION_DETAILS: {
                valueFields.put(JSON_FIELD_RESPONSE_TYPE, new JSONString(JSON_RESPONSE_TYPE_VALIDATION_PERFORMED));
                ArrayList<JSONObject> validationDetailsValues = new ArrayList<JSONObject>(this.validationResults.size());
                for (PasswordQualityRequirementValidationResult result : this.validationResults) {
                    validationDetailsValues.add(PasswordValidationDetailsResponseControl.encodeValidationResultJSON(result));
                }
                valueFields.put(JSON_FIELD_VALIDATION_DETAILS, new JSONArray(validationDetailsValues));
                break;
            }
            case NO_PASSWORD_PROVIDED: {
                valueFields.put(JSON_FIELD_RESPONSE_TYPE, new JSONString(JSON_RESPONSE_TYPE_NO_PASSWORD_PROVIDED));
                break;
            }
            case MULTIPLE_PASSWORDS_PROVIDED: {
                valueFields.put(JSON_FIELD_RESPONSE_TYPE, new JSONString(JSON_RESPONSE_TYPE_MULTIPLE_PASSWORDS_PROVIDED));
                break;
            }
            case NO_VALIDATION_ATTEMPTED: {
                valueFields.put(JSON_FIELD_RESPONSE_TYPE, new JSONString(JSON_RESPONSE_TYPE_NO_VALIDATION_ATTEMPTED));
            }
        }
        valueFields.put(JSON_FIELD_MISSING_CURRENT_PASSWORD, new JSONBoolean(this.missingCurrentPassword));
        valueFields.put(JSON_FIELD_MUST_CHANGE_PASSWORD, new JSONBoolean(this.mustChangePassword));
        if (this.secondsUntilExpiration != null) {
            valueFields.put(JSON_FIELD_SECONDS_UNTIL_EXPIRATION, new JSONNumber(this.secondsUntilExpiration.intValue()));
        }
        return new JSONObject(new JSONField("oid", PASSWORD_VALIDATION_DETAILS_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_PW_VALIDATION_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    private static JSONObject encodeValidationResultJSON(@NotNull PasswordQualityRequirementValidationResult result) {
        Map<String, String> clientSideValidationProperties;
        PasswordQualityRequirement requirement = result.getPasswordRequirement();
        LinkedHashMap<String, JSONValue> requirementFields = new LinkedHashMap<String, JSONValue>();
        requirementFields.put(JSON_FIELD_DESCRIPTION, new JSONString(requirement.getDescription()));
        String clientSideValidationType = requirement.getClientSideValidationType();
        if (clientSideValidationType != null) {
            requirementFields.put(JSON_FIELD_CLIENT_SIDE_VALIDATION_TYPE, new JSONString(clientSideValidationType));
        }
        if (!(clientSideValidationProperties = requirement.getClientSideValidationProperties()).isEmpty()) {
            ArrayList<JSONObject> propertyValues = new ArrayList<JSONObject>(clientSideValidationProperties.size());
            for (Map.Entry<String, String> e : clientSideValidationProperties.entrySet()) {
                propertyValues.add(new JSONObject(new JSONField(JSON_FIELD_PROPERTY_NAME, e.getKey()), new JSONField(JSON_FIELD_PROPERTY_VALUE, e.getValue())));
            }
            requirementFields.put(JSON_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES, new JSONArray(propertyValues));
        }
        LinkedHashMap<String, JSONValue> detailsFields = new LinkedHashMap<String, JSONValue>();
        detailsFields.put(JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, new JSONObject(requirementFields));
        detailsFields.put(JSON_FIELD_REQUIREMENT_SATISFIED, new JSONBoolean(result.requirementSatisfied()));
        String additionalInformation = result.getAdditionalInfo();
        if (additionalInformation != null) {
            detailsFields.put(JSON_FIELD_ADDITIONAL_INFORMATION, new JSONString(additionalInformation));
        }
        return new JSONObject(detailsFields);
    }

    @NotNull
    public static PasswordValidationDetailsResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        List<PasswordQualityRequirementValidationResult> validationResults;
        PasswordValidationDetailsResponseType responseType;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new PasswordValidationDetailsResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String responseTypeStr = valueObject.getFieldAsString(JSON_FIELD_RESPONSE_TYPE);
        if (responseTypeStr == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_VALUE_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_RESPONSE_TYPE));
        }
        switch (responseTypeStr) {
            case "validation-performed": {
                responseType = PasswordValidationDetailsResponseType.VALIDATION_DETAILS;
                break;
            }
            case "no-password-provided": {
                responseType = PasswordValidationDetailsResponseType.NO_PASSWORD_PROVIDED;
                break;
            }
            case "multiple-passwords-provided": {
                responseType = PasswordValidationDetailsResponseType.MULTIPLE_PASSWORDS_PROVIDED;
                break;
            }
            case "no-validation-attempted": {
                responseType = PasswordValidationDetailsResponseType.NO_VALIDATION_ATTEMPTED;
                break;
            }
            default: {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_UNKNOWN_RESPONSE_TYPE.get(controlObject.toSingleLineString(), JSON_FIELD_RESPONSE_TYPE, responseTypeStr));
            }
        }
        List<JSONValue> validationDetailsValues = valueObject.getFieldAsArray(JSON_FIELD_VALIDATION_DETAILS);
        if (validationDetailsValues == null) {
            validationResults = Collections.emptyList();
        } else {
            validationResults = new ArrayList(validationDetailsValues.size());
            for (JSONValue v : validationDetailsValues) {
                validationResults.add(PasswordValidationDetailsResponseControl.decodeValidationResultJSON(controlObject, v, strict));
            }
        }
        Boolean missingCurrentPassword = valueObject.getFieldAsBoolean(JSON_FIELD_MISSING_CURRENT_PASSWORD);
        if (missingCurrentPassword == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_VALUE_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_MISSING_CURRENT_PASSWORD));
        }
        Boolean mustChangePassword = valueObject.getFieldAsBoolean(JSON_FIELD_MUST_CHANGE_PASSWORD);
        if (mustChangePassword == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_VALUE_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_MUST_CHANGE_PASSWORD));
        }
        Integer secondsUntilExpiration = valueObject.getFieldAsInteger(JSON_FIELD_SECONDS_UNTIL_EXPIRATION);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_RESPONSE_TYPE, JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_MISSING_CURRENT_PASSWORD, JSON_FIELD_MUST_CHANGE_PASSWORD, JSON_FIELD_SECONDS_UNTIL_EXPIRATION)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new PasswordValidationDetailsResponseControl(responseType, validationResults, missingCurrentPassword, mustChangePassword, secondsUntilExpiration);
    }

    @NotNull
    private static PasswordQualityRequirementValidationResult decodeValidationResultJSON(@NotNull JSONObject controlObject, @NotNull JSONValue resultValue, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        Boolean requirementSatisfied;
        if (!(resultValue instanceof JSONObject)) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_RESULT_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS));
        }
        JSONObject resultObject = (JSONObject)resultValue;
        JSONObject requirementObject = resultObject.getFieldAsObject(JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT);
        if (requirementObject == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_RESULT_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT));
        }
        String requirementDescription = requirementObject.getFieldAsString(JSON_FIELD_DESCRIPTION);
        if (requirementDescription == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_REQUIREMENT_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, JSON_FIELD_DESCRIPTION));
        }
        String clientSideValidationType = requirementObject.getFieldAsString(JSON_FIELD_CLIENT_SIDE_VALIDATION_TYPE);
        LinkedHashMap<String, String> clientSideValidationProperties = new LinkedHashMap<String, String>();
        List<JSONValue> clientSideValidationPropertyValues = requirementObject.getFieldAsArray(JSON_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES);
        if (clientSideValidationPropertyValues != null) {
            for (JSONValue v : clientSideValidationPropertyValues) {
                List<String> unrecognizedFields2;
                if (!(v instanceof JSONObject)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_REQUIREMENT_PROP_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, JSON_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES));
                }
                JSONObject propObject = (JSONObject)v;
                String name = propObject.getFieldAsString(JSON_FIELD_PROPERTY_NAME);
                if (name == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_REQUIREMENT_PROP_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, JSON_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES, JSON_FIELD_PROPERTY_NAME));
                }
                String value = propObject.getFieldAsString(JSON_FIELD_PROPERTY_VALUE);
                if (value == null) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_REQUIREMENT_PROP_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, JSON_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES, JSON_FIELD_PROPERTY_VALUE));
                }
                if (strict && !(unrecognizedFields2 = JSONControlDecodeHelper.getControlObjectUnexpectedFields(propObject, JSON_FIELD_PROPERTY_NAME, JSON_FIELD_PROPERTY_VALUE)).isEmpty()) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_UNRECOGNIZED_PROP_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, JSON_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES, unrecognizedFields2.get(0)));
                }
                clientSideValidationProperties.put(name, value);
            }
        }
        if ((requirementSatisfied = resultObject.getFieldAsBoolean(JSON_FIELD_REQUIREMENT_SATISFIED)) == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_RESULT_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, JSON_FIELD_REQUIREMENT_SATISFIED));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(resultObject, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, JSON_FIELD_REQUIREMENT_SATISFIED, JSON_FIELD_ADDITIONAL_INFORMATION)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_VALIDATION_RESPONSE_JSON_RESULT_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_VALIDATION_DETAILS, JSON_FIELD_PASSWORD_QUALITY_REQUIREMENT, unrecognizedFields.get(0)));
        }
        String additionalInformation = resultObject.getFieldAsString(JSON_FIELD_ADDITIONAL_INFORMATION);
        PasswordQualityRequirement requirement = new PasswordQualityRequirement(requirementDescription, clientSideValidationType, clientSideValidationProperties);
        return new PasswordQualityRequirementValidationResult(requirement, requirementSatisfied, additionalInformation);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PasswordValidationDetailsResponseControl(responseType='");
        buffer.append(this.responseType.name());
        buffer.append('\'');
        if (this.responseType == PasswordValidationDetailsResponseType.VALIDATION_DETAILS) {
            buffer.append(", validationDetails={");
            Iterator<PasswordQualityRequirementValidationResult> iterator = this.validationResults.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(buffer);
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        buffer.append(", missingCurrentPassword=");
        buffer.append(this.missingCurrentPassword);
        buffer.append(", mustChangePassword=");
        buffer.append(this.mustChangePassword);
        if (this.secondsUntilExpiration != null) {
            buffer.append(", secondsUntilExpiration=");
            buffer.append(this.secondsUntilExpiration);
        }
        buffer.append("})");
    }
}

