/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.apache.iotdb.commons.consensus.iotv2.container.IoTV2GlobalComponentContainer;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.pipe.metric.PipeConsensusSyncLagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsensusFactory {
    public static final String CONSTRUCT_FAILED_MSG = "Construct consensusImpl failed, Please check your consensus className %s";
    public static final String SIMPLE_CONSENSUS = "org.apache.iotdb.consensus.simple.SimpleConsensus";
    public static final String RATIS_CONSENSUS = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    public static final String IOT_CONSENSUS = "org.apache.iotdb.consensus.iot.IoTConsensus";
    public static final String REAL_PIPE_CONSENSUS = "org.apache.iotdb.consensus.pipe.PipeConsensus";
    public static final String IOT_CONSENSUS_V2 = "org.apache.iotdb.consensus.iot.IoTConsensusV2";
    public static final String IOT_CONSENSUS_V2_BATCH_MODE = "batch";
    public static final String IOT_CONSENSUS_V2_STREAM_MODE = "stream";
    private static final Logger logger = LoggerFactory.getLogger(ConsensusFactory.class);

    private ConsensusFactory() {
        throw new IllegalStateException("Utility class ConsensusFactory");
    }

    public static Optional<IConsensus> getConsensusImpl(String className, ConsensusConfig config, IStateMachine.Registry registry) {
        try {
            if (className.equals(IOT_CONSENSUS_V2)) {
                className = REAL_PIPE_CONSENSUS;
                IoTV2GlobalComponentContainer.build();
                PipeConsensusSyncLagManager.build();
            }
            Class<?> executor = Class.forName(className);
            Constructor<?> executorConstructor = executor.getDeclaredConstructor(ConsensusConfig.class, IStateMachine.Registry.class);
            executorConstructor.setAccessible(true);
            return Optional.of((IConsensus)executorConstructor.newInstance(config, registry));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Couldn't Construct IConsensus class: {}", (Object)className, (Object)e);
            return Optional.empty();
        }
    }
}

