/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class QueryNextRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=619");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=621");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=620");
    private final RequestHeader requestHeader;
    private final Boolean releaseContinuationPoint;
    private final ByteString continuationPoint;

    public QueryNextRequest(RequestHeader requestHeader, Boolean releaseContinuationPoint, ByteString continuationPoint) {
        this.requestHeader = requestHeader;
        this.releaseContinuationPoint = releaseContinuationPoint;
        this.continuationPoint = continuationPoint;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Boolean getReleaseContinuationPoint() {
        return this.releaseContinuationPoint;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    protected QueryNextRequest(QueryNextRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((QueryNextRequestBuilder)b).requestHeader;
        this.releaseContinuationPoint = ((QueryNextRequestBuilder)b).releaseContinuationPoint;
        this.continuationPoint = ((QueryNextRequestBuilder)b).continuationPoint;
    }

    public static QueryNextRequestBuilder<?, ?> builder() {
        return new QueryNextRequestBuilderImpl();
    }

    public QueryNextRequestBuilder<?, ?> toBuilder() {
        return new QueryNextRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryNextRequest)) {
            return false;
        }
        QueryNextRequest other = (QueryNextRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$releaseContinuationPoint = this.getReleaseContinuationPoint();
        Boolean other$releaseContinuationPoint = other.getReleaseContinuationPoint();
        if (this$releaseContinuationPoint == null ? other$releaseContinuationPoint != null : !((Object)this$releaseContinuationPoint).equals(other$releaseContinuationPoint)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        ByteString this$continuationPoint = this.getContinuationPoint();
        ByteString other$continuationPoint = other.getContinuationPoint();
        return !(this$continuationPoint == null ? other$continuationPoint != null : !((Object)this$continuationPoint).equals(other$continuationPoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryNextRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $releaseContinuationPoint = this.getReleaseContinuationPoint();
        result = result * 59 + ($releaseContinuationPoint == null ? 43 : ((Object)$releaseContinuationPoint).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        ByteString $continuationPoint = this.getContinuationPoint();
        result = result * 59 + ($continuationPoint == null ? 43 : ((Object)$continuationPoint).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QueryNextRequest(requestHeader=" + this.getRequestHeader() + ", releaseContinuationPoint=" + this.getReleaseContinuationPoint() + ", continuationPoint=" + this.getContinuationPoint() + ")";
    }

    private static final class QueryNextRequestBuilderImpl
    extends QueryNextRequestBuilder<QueryNextRequest, QueryNextRequestBuilderImpl> {
        private QueryNextRequestBuilderImpl() {
        }

        @Override
        protected QueryNextRequestBuilderImpl self() {
            return this;
        }

        @Override
        public QueryNextRequest build() {
            return new QueryNextRequest(this);
        }
    }

    public static abstract class QueryNextRequestBuilder<C extends QueryNextRequest, B extends QueryNextRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private Boolean releaseContinuationPoint;
        private ByteString continuationPoint;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QueryNextRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(QueryNextRequest instance, QueryNextRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.releaseContinuationPoint(instance.releaseContinuationPoint);
            b.continuationPoint(instance.continuationPoint);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B releaseContinuationPoint(Boolean releaseContinuationPoint) {
            this.releaseContinuationPoint = releaseContinuationPoint;
            return (B)this.self();
        }

        public B continuationPoint(ByteString continuationPoint) {
            this.continuationPoint = continuationPoint;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "QueryNextRequest.QueryNextRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", releaseContinuationPoint=" + this.releaseContinuationPoint + ", continuationPoint=" + this.continuationPoint + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryNextRequest> {
        @Override
        public Class<QueryNextRequest> getType() {
            return QueryNextRequest.class;
        }

        @Override
        public QueryNextRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            Boolean releaseContinuationPoint = decoder.readBoolean("ReleaseContinuationPoint");
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            return new QueryNextRequest(requestHeader, releaseContinuationPoint, continuationPoint);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryNextRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeBoolean("ReleaseContinuationPoint", value.getReleaseContinuationPoint());
            encoder.writeByteString("ContinuationPoint", value.getContinuationPoint());
        }
    }
}

