/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.NoHeaderNodeException;
import org.apache.iotdb.cluster.exception.NotInSameGroupException;
import org.apache.iotdb.cluster.exception.PartitionTableUnavailableException;
import org.apache.iotdb.cluster.log.logtypes.AddNodeLog;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.StoppedMemberManager;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.monitor.NodeReport;
import org.apache.iotdb.cluster.server.service.DataAsyncService;
import org.apache.iotdb.cluster.server.service.DataGroupEngineMBean;
import org.apache.iotdb.cluster.server.service.DataSyncService;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGroupEngine
implements IService,
DataGroupEngineMBean {
    private static final Logger logger = LoggerFactory.getLogger(DataGroupEngine.class);
    private static final Map<RaftNode, DataGroupMember> headerGroupMap = new ConcurrentHashMap<RaftNode, DataGroupMember>();
    private static final Map<RaftNode, DataAsyncService> asyncServiceMap = new ConcurrentHashMap<RaftNode, DataAsyncService>();
    private static final Map<RaftNode, DataSyncService> syncServiceMap = new ConcurrentHashMap<RaftNode, DataSyncService>();
    private final StoppedMemberManager stoppedMemberManager;
    private PartitionTable partitionTable;
    private DataGroupMember.Factory dataMemberFactory;
    private static MetaGroupMember metaGroupMember;
    private final Node thisNode = ClusterIoTDB.getInstance().getThisNode();
    private static TProtocolFactory protocolFactory;

    private DataGroupEngine() {
        this.dataMemberFactory = new DataGroupMember.Factory(protocolFactory, metaGroupMember);
        this.stoppedMemberManager = new StoppedMemberManager(this.dataMemberFactory);
    }

    public static DataGroupEngine getInstance() {
        if (metaGroupMember == null || protocolFactory == null) {
            logger.error("MetaGroupMember or protocolFactory init failed.");
        }
        return InstanceHolder.Instance;
    }

    public void resetFactory() {
        this.dataMemberFactory = new DataGroupMember.Factory(protocolFactory, metaGroupMember);
    }

    public DataGroupEngine(DataGroupMember.Factory dataMemberFactory, MetaGroupMember metaGroupMember) {
        DataGroupEngine.metaGroupMember = metaGroupMember;
        this.dataMemberFactory = dataMemberFactory;
        this.stoppedMemberManager = new StoppedMemberManager(dataMemberFactory);
    }

    public void start() throws StartupException {
    }

    public void stop() {
        this.closeLogManagers();
        for (DataGroupMember member : headerGroupMap.values()) {
            member.stop();
        }
    }

    public ServiceType getID() {
        return ServiceType.CLUSTER_DATA_ENGINE;
    }

    public void closeLogManagers() {
        for (DataGroupMember member : headerGroupMap.values()) {
            member.closeLogManager();
        }
    }

    public <T> DataAsyncService getDataAsyncService(RaftNode header, AsyncMethodCallback<T> resultHandler, Object request) {
        return asyncServiceMap.computeIfAbsent(header, h -> {
            DataGroupMember dataMember = this.getDataMember(header, resultHandler, request);
            return dataMember != null ? new DataAsyncService(dataMember) : null;
        });
    }

    public DataSyncService getDataSyncService(RaftNode header) {
        return syncServiceMap.computeIfAbsent(header, h -> {
            DataGroupMember dataMember = this.getDataMember(header, null, null);
            return dataMember != null ? new DataSyncService(dataMember) : null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataGroupMember addDataGroupMember(DataGroupMember dataGroupMember, RaftNode header) {
        Map<RaftNode, DataGroupMember> map = headerGroupMap;
        synchronized (map) {
            if (headerGroupMap.containsKey(header)) {
                logger.debug("Group {} already exist.", dataGroupMember.getAllNodes());
                return headerGroupMap.get(header);
            }
            this.stoppedMemberManager.remove(header);
            headerGroupMap.put(header, dataGroupMember);
            dataGroupMember.start();
        }
        logger.info("Add group {} successfully.", (Object)dataGroupMember.getName());
        this.resetServiceCache(header);
        return dataGroupMember;
    }

    private void resetServiceCache(RaftNode header) {
        asyncServiceMap.remove(header);
        syncServiceMap.remove(header);
    }

    public <T> DataGroupMember getDataMember(RaftNode header, AsyncMethodCallback<T> resultHandler, Object request) {
        if (header.getNode() == null) {
            if (resultHandler != null) {
                resultHandler.onError((Exception)new NoHeaderNodeException());
            }
            return null;
        }
        DataGroupMember member = this.stoppedMemberManager.get(header);
        if (member != null) {
            return member;
        }
        Exception ex = null;
        member = headerGroupMap.get(header);
        if (member != null) {
            return member;
        }
        logger.info("Received a request \"{}\" from unregistered header {}", request, (Object)header);
        if (this.partitionTable != null) {
            try {
                member = this.createNewMember(header);
            }
            catch (CheckConsistencyException | NotInSameGroupException e) {
                ex = e;
            }
        } else {
            logger.info("Partition is not ready, cannot create member");
            ex = new PartitionTableUnavailableException(this.thisNode);
        }
        if (ex != null && resultHandler != null) {
            resultHandler.onError(ex);
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataGroupMember createNewMember(RaftNode header) throws NotInSameGroupException, CheckConsistencyException {
        DataGroupMember member;
        PartitionGroup partitionGroup = this.partitionTable.getPartitionGroup(header);
        if (partitionGroup == null || !partitionGroup.contains(this.thisNode)) {
            metaGroupMember.syncLeaderWithConsistencyCheck(true);
            partitionGroup = this.partitionTable.getPartitionGroup(header);
        }
        Map<RaftNode, DataGroupMember> map = headerGroupMap;
        synchronized (map) {
            member = headerGroupMap.get(header);
            if (member != null) {
                return member;
            }
            if (partitionGroup == null || !partitionGroup.contains(this.thisNode)) {
                member = this.stoppedMemberManager.get(header);
                if (member != null) {
                    return member;
                }
                logger.info("This node {} does not belong to the group {}, header {}", new Object[]{this.thisNode, partitionGroup, header});
                throw new NotInSameGroupException(partitionGroup, this.thisNode);
            }
            member = this.dataMemberFactory.create(partitionGroup);
            headerGroupMap.put(header, member);
            this.stoppedMemberManager.remove(header);
            logger.info("Created a member for header {}, group is {}", (Object)header, (Object)partitionGroup);
            member.start();
        }
        return member;
    }

    public void preAddNodeForDataGroup(AddNodeLog log, DataGroupMember targetDataGroupMember) {
        metaGroupMember.syncLocalApply(log.getMetaLogIndex() - 1L, false);
        if (!metaGroupMember.getPartitionTable().deserialize(log.getPartitionTable())) {
            return;
        }
        targetDataGroupMember.preAddNode(log.getNewNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node node, NodeAdditionResult result) {
        if (node.equals(this.thisNode)) {
            return;
        }
        Iterator<Map.Entry<RaftNode, DataGroupMember>> entryIterator = headerGroupMap.entrySet().iterator();
        Map<RaftNode, DataGroupMember> map = headerGroupMap;
        synchronized (map) {
            while (entryIterator.hasNext()) {
                Map.Entry<RaftNode, DataGroupMember> entry = entryIterator.next();
                DataGroupMember dataGroupMember = entry.getValue();
                boolean shouldLeave = dataGroupMember.addNode(node, result);
                if (!shouldLeave) continue;
                logger.info("This node does not belong to {} any more", dataGroupMember.getAllNodes());
                this.removeMember(entry.getKey(), entry.getValue(), false);
                entryIterator.remove();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Data cluster server: start to handle new groups when adding new node {}", (Object)node);
            }
            for (PartitionGroup newGroup : result.getNewGroupList()) {
                if (!newGroup.contains(this.thisNode)) continue;
                RaftNode header = newGroup.getHeader();
                logger.info("Adding this node into a new group {}", (Object)newGroup);
                DataGroupMember dataGroupMember = this.dataMemberFactory.create(newGroup);
                dataGroupMember = this.addDataGroupMember(dataGroupMember, header);
                dataGroupMember.pullNodeAdditionSnapshots(((SlotPartitionTable)this.partitionTable).getNodeSlots(header), node);
            }
        }
    }

    public void pullSnapshots() {
        for (int raftId = 0; raftId < ClusterDescriptor.getInstance().getConfig().getMultiRaftFactor(); ++raftId) {
            RaftNode raftNode = new RaftNode(this.thisNode, raftId);
            List<Integer> slots = ((SlotPartitionTable)this.partitionTable).getNodeSlots(raftNode);
            DataGroupMember dataGroupMember = headerGroupMap.get(raftNode);
            dataGroupMember.pullNodeAdditionSnapshots(slots, this.thisNode);
        }
    }

    private void removeMember(RaftNode header, DataGroupMember dataGroupMember, boolean removedGroup) {
        dataGroupMember.setReadOnly();
        if (!removedGroup) {
            dataGroupMember.stop();
        } else if (dataGroupMember.getCharacter() != NodeCharacter.LEADER) {
            new Thread(() -> {
                try {
                    dataGroupMember.syncLeader(null);
                    dataGroupMember.stop();
                }
                catch (CheckConsistencyException e) {
                    logger.warn("Failed to check consistency.", (Throwable)e);
                }
            }).start();
        }
        this.stoppedMemberManager.put(header, dataGroupMember);
        logger.info("Data group member has removed, header {}, group is {}.", (Object)header, dataGroupMember.getAllNodes());
    }

    public void buildDataGroupMembers(PartitionTable partitionTable) {
        this.setPartitionTable(partitionTable);
        for (DataGroupMember value : headerGroupMap.values()) {
            value.stop();
        }
        for (DataGroupMember value : headerGroupMap.values()) {
            value.setUnchanged(false);
        }
        List<PartitionGroup> partitionGroups = partitionTable.getLocalGroups();
        for (PartitionGroup partitionGroup : partitionGroups) {
            RaftNode header = partitionGroup.getHeader();
            DataGroupMember prevMember = headerGroupMap.get(header);
            if (prevMember == null || !prevMember.getAllNodes().equals(partitionGroup)) {
                logger.info("Building member of data group: {}", (Object)partitionGroup);
                DataGroupMember dataGroupMember = this.dataMemberFactory.create(partitionGroup);
                this.addDataGroupMember(dataGroupMember, header);
                dataGroupMember.setUnchanged(true);
                continue;
            }
            prevMember.setUnchanged(true);
            prevMember.start();
        }
        headerGroupMap.entrySet().removeIf(e -> !((DataGroupMember)e.getValue()).isUnchanged());
        logger.info("Data group members are ready");
    }

    public void preRemoveNodeForDataGroup(RemoveNodeLog log, DataGroupMember targetDataGroupMember) {
        metaGroupMember.syncLocalApply(log.getMetaLogIndex() - 1L, false);
        if (!metaGroupMember.getPartitionTable().deserialize(log.getPartitionTable())) {
            return;
        }
        logger.debug("Pre removing a node {} from {}", (Object)log.getRemovedNode(), targetDataGroupMember.getAllNodes());
        targetDataGroupMember.preRemoveNode(log.getRemovedNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node, NodeRemovalResult removalResult) {
        Iterator<Map.Entry<RaftNode, DataGroupMember>> entryIterator = headerGroupMap.entrySet().iterator();
        Map<RaftNode, DataGroupMember> map = headerGroupMap;
        synchronized (map) {
            while (entryIterator.hasNext()) {
                Map.Entry<RaftNode, DataGroupMember> entry = entryIterator.next();
                DataGroupMember dataGroupMember = entry.getValue();
                if (dataGroupMember.getHeader().getNode().equals(node) || node.equals(this.thisNode)) {
                    entryIterator.remove();
                    this.removeMember(entry.getKey(), dataGroupMember, dataGroupMember.getHeader().getNode().equals(node));
                    continue;
                }
                dataGroupMember.removeNode(node);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Data cluster server: start to handle new groups and pulling data when removing node {}", (Object)node);
            }
            for (PartitionGroup group : this.partitionTable.getLocalGroups()) {
                RaftNode header = group.getHeader();
                if (!headerGroupMap.containsKey(header)) {
                    logger.info("{} should join a new group {}", (Object)this.thisNode, (Object)group);
                    DataGroupMember dataGroupMember = this.dataMemberFactory.create(group);
                    this.addDataGroupMember(dataGroupMember, header);
                }
                headerGroupMap.get(header).pullSlots(removalResult);
            }
        }
    }

    public void setPartitionTable(PartitionTable partitionTable) {
        this.partitionTable = partitionTable;
    }

    public List<NodeReport.DataMemberReport> genMemberReports() {
        ArrayList<NodeReport.DataMemberReport> dataMemberReports = new ArrayList<NodeReport.DataMemberReport>();
        for (DataGroupMember value : headerGroupMap.values()) {
            dataMemberReports.add(value.genReport());
        }
        return dataMemberReports;
    }

    public Map<RaftNode, DataGroupMember> getHeaderGroupMap() {
        return headerGroupMap;
    }

    public static void setProtocolFactory(TProtocolFactory protocolFactory) {
        DataGroupEngine.protocolFactory = protocolFactory;
    }

    public static void setMetaGroupMember(MetaGroupMember metaGroupMember) {
        DataGroupEngine.metaGroupMember = metaGroupMember;
    }

    @Override
    public String getHeaderGroupMapAsString() {
        return headerGroupMap.toString();
    }

    @Override
    public int getAsyncServiceMapSize() {
        return asyncServiceMap.size();
    }

    @Override
    public int getSyncServiceMapSize() {
        return syncServiceMap.size();
    }

    @Override
    public String getPartitionTable() {
        return this.partitionTable.toString();
    }

    private static class InstanceHolder {
        private static final DataGroupEngine Instance = new DataGroupEngine();

        private InstanceHolder() {
        }
    }
}

