/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.handler;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.thrift.handler.BaseServerContextHandler;
import org.apache.iotdb.db.service.thrift.handler.RPCServiceThriftHandlerMetrics;
import org.apache.iotdb.db.service.thrift.impl.TSServiceImpl;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCServiceThriftHandler
extends BaseServerContextHandler
implements TServerEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(RPCServiceThriftHandler.class);
    private TSServiceImpl serviceImpl;
    private AtomicLong thriftConnectionNumber = new AtomicLong(0L);

    public RPCServiceThriftHandler(TSServiceImpl serviceImpl) {
        this.serviceImpl = serviceImpl;
        MetricService.getInstance().addMetricSet(new RPCServiceThriftHandlerMetrics(this.thriftConnectionNumber));
    }

    @Override
    public ServerContext createContext(TProtocol in, TProtocol out) {
        this.thriftConnectionNumber.incrementAndGet();
        return super.createContext(in, out);
    }

    @Override
    public void deleteContext(ServerContext arg0, TProtocol arg1, TProtocol arg2) {
        this.serviceImpl.handleClientExit();
        this.thriftConnectionNumber.decrementAndGet();
        super.deleteContext(arg0, arg1, arg2);
    }

    public void preServe() {
    }

    public void processContext(ServerContext arg0, TTransport arg1, TTransport arg2) {
    }
}

