/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.hc.core5.http.io.entity.NullEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestNullEntity {
    TestNullEntity() {
    }

    @Test
    void testLength() {
        Assertions.assertEquals((long)0L, (long)NullEntity.INSTANCE.getContentLength());
    }

    @Test
    void testContentType() {
        Assertions.assertNull((Object)NullEntity.INSTANCE.getContentType());
    }

    @Test
    void testContentEncoding() {
        Assertions.assertNull((Object)NullEntity.INSTANCE.getContentEncoding());
    }

    @Test
    void testTrailerNames() {
        Assertions.assertEquals(Collections.emptySet(), (Object)NullEntity.INSTANCE.getTrailerNames());
    }

    @Test
    void testContentStream() throws IOException {
        try (InputStream content = NullEntity.INSTANCE.getContent();){
            Assertions.assertEquals((int)-1, (int)content.read());
        }
        content = NullEntity.INSTANCE.getContent();
        var2_2 = null;
        try {
            Assertions.assertEquals((int)-1, (int)content.read());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (content != null) {
                if (var2_2 != null) {
                    try {
                        content.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    content.close();
                }
            }
        }
    }

    @Test
    void testWriteTo() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NullEntity.INSTANCE.writeTo((OutputStream)baos);
        Assertions.assertEquals((int)0, (int)baos.size());
    }

    @Test
    void testIsStreaming() {
        Assertions.assertFalse((boolean)NullEntity.INSTANCE.isStreaming());
    }

    @Test
    void testIsChunked() {
        Assertions.assertFalse((boolean)NullEntity.INSTANCE.isChunked());
    }
}

