/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStateMachineProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStateMachineProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestStateMachineProcedure.class);
    private static final Exception TEST_FAILURE_EXCEPTION = new Exception("test failure"){
        private static final long serialVersionUID = 2147942238987041310L;

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Exception)) {
                return false;
            }
            return this.getMessage().equals(((Exception)other).getMessage());
        }

        public int hashCode() {
            return this.getMessage().hashCode();
        }
    };
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private ProcedureExecutor<TestProcEnv> procExecutor;
    private ProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.logDir);
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)new TestProcEnv(), this.procStore);
        this.procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(this.procExecutor, 1, true);
    }

    @After
    public void tearDown() throws IOException {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.procExecutor, false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)this.procExecutor.isRunning());
        this.procExecutor.stop();
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortStuckProcedure() throws InterruptedException {
        try {
            ((TestProcEnv)this.procExecutor.getEnvironment()).loop = true;
            TestSMProcedure proc = new TestSMProcedure();
            long procId = this.procExecutor.submitProcedure((Procedure)proc);
            Thread.sleep(1000 + (int)(Math.random() * 4001.0));
            proc.abort(this.procExecutor.getEnvironment());
            ProcedureTestingUtility.waitProcedure(this.procExecutor, procId);
            Assert.assertEquals((Object)true, (Object)proc.isFailed());
        }
        finally {
            ((TestProcEnv)this.procExecutor.getEnvironment()).loop = false;
        }
    }

    @Test
    public void testChildOnLastStep() {
        long procId = this.procExecutor.submitProcedure((Procedure)new TestSMProcedure());
        ProcedureTestingUtility.waitProcedure(this.procExecutor, procId);
        Assert.assertEquals((long)3L, (long)((TestProcEnv)this.procExecutor.getEnvironment()).execCount.get());
        Assert.assertEquals((long)0L, (long)((TestProcEnv)this.procExecutor.getEnvironment()).rollbackCount.get());
        ProcedureTestingUtility.assertProcNotFailed(this.procExecutor, procId);
    }

    @Test
    public void testChildOnLastStepDoubleExecution() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.procExecutor, true);
        long procId = this.procExecutor.submitProcedure((Procedure)new TestSMProcedure());
        ProcedureTestingUtility.testRecoveryAndDoubleExecution(this.procExecutor, procId);
        Assert.assertEquals((long)6L, (long)((TestProcEnv)this.procExecutor.getEnvironment()).execCount.get());
        Assert.assertEquals((long)0L, (long)((TestProcEnv)this.procExecutor.getEnvironment()).rollbackCount.get());
        ProcedureTestingUtility.assertProcNotFailed(this.procExecutor, procId);
    }

    @Test
    public void testChildOnLastStepWithRollback() {
        ((TestProcEnv)this.procExecutor.getEnvironment()).triggerChildRollback = true;
        long procId = this.procExecutor.submitProcedure((Procedure)new TestSMProcedure());
        ProcedureTestingUtility.waitProcedure(this.procExecutor, procId);
        Assert.assertEquals((long)3L, (long)((TestProcEnv)this.procExecutor.getEnvironment()).execCount.get());
        Assert.assertEquals((long)3L, (long)((TestProcEnv)this.procExecutor.getEnvironment()).rollbackCount.get());
        Throwable cause = ProcedureTestingUtility.assertProcFailed(this.procExecutor, procId);
        Assert.assertEquals((Object)TEST_FAILURE_EXCEPTION, (Object)cause);
    }

    @Test
    public void testChildNormalRollbackStateCount() {
        ((TestProcEnv)this.procExecutor.getEnvironment()).triggerChildRollback = true;
        TestSMProcedureBadRollback testNormalRollback = new TestSMProcedureBadRollback();
        long procId = this.procExecutor.submitProcedure((Procedure)testNormalRollback);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, procId);
        Assert.assertEquals((long)0L, (long)testNormalRollback.stateCount);
    }

    @Test
    public void testChildBadRollbackStateCount() {
        ((TestProcEnv)this.procExecutor.getEnvironment()).triggerChildRollback = true;
        TestSMProcedureBadRollback testBadRollback = new TestSMProcedureBadRollback();
        long procId = this.procExecutor.submitProcedure((Procedure)testBadRollback);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, procId);
        Assert.assertEquals((long)0L, (long)testBadRollback.stateCount);
    }

    @Test
    public void testChildOnLastStepWithRollbackDoubleExecution() throws Exception {
        ((TestProcEnv)this.procExecutor.getEnvironment()).triggerChildRollback = true;
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.procExecutor, true);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdateInRollback(this.procExecutor, true);
        long procId = this.procExecutor.submitProcedure((Procedure)new TestSMProcedure());
        ProcedureTestingUtility.testRecoveryAndDoubleExecution(this.procExecutor, procId, true);
        Assert.assertEquals((long)6L, (long)((TestProcEnv)this.procExecutor.getEnvironment()).execCount.get());
        Assert.assertEquals((long)6L, (long)((TestProcEnv)this.procExecutor.getEnvironment()).rollbackCount.get());
        Throwable cause = ProcedureTestingUtility.assertProcFailed(this.procExecutor, procId);
        Assert.assertEquals((Object)TEST_FAILURE_EXCEPTION, (Object)cause);
    }

    public static class TestProcEnv {
        AtomicInteger execCount = new AtomicInteger(0);
        AtomicInteger rollbackCount = new AtomicInteger(0);
        boolean triggerChildRollback = false;
        boolean loop = false;
    }

    public static class SimpleChildProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestProcEnv> {
        @Override
        protected Procedure<TestProcEnv>[] execute(TestProcEnv env) {
            LOG.info("EXEC " + (Object)((Object)this));
            env.execCount.incrementAndGet();
            if (env.triggerChildRollback) {
                this.setFailure("test-failure", TEST_FAILURE_EXCEPTION);
            }
            return null;
        }

        @Override
        protected void rollback(TestProcEnv env) {
            LOG.info("ROLLBACK " + (Object)((Object)this));
            env.rollbackCount.incrementAndGet();
        }
    }

    public static class TestSMProcedureBadRollback
    extends StateMachineProcedure<TestProcEnv, TestSMProcedureState> {
        protected StateMachineProcedure.Flow executeFromState(TestProcEnv env, TestSMProcedureState state) {
            LOG.info("EXEC " + (Object)((Object)state) + " " + (Object)((Object)this));
            env.execCount.incrementAndGet();
            switch (state) {
                case STEP_1: {
                    if (env.loop) break;
                    this.setNextState((Object)TestSMProcedureState.STEP_2);
                    break;
                }
                case STEP_2: {
                    this.addChildProcedure(new SimpleChildProcedure[]{new SimpleChildProcedure()});
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }

        protected boolean isRollbackSupported(TestSMProcedureState state) {
            return true;
        }

        protected void rollbackState(TestProcEnv env, TestSMProcedureState state) {
            LOG.info("ROLLBACK " + (Object)((Object)state) + " " + (Object)((Object)this));
            env.rollbackCount.incrementAndGet();
        }

        protected TestSMProcedureState getState(int stateId) {
            return TestSMProcedureState.values()[stateId];
        }

        protected int getStateId(TestSMProcedureState state) {
            return state.ordinal();
        }

        protected TestSMProcedureState getInitialState() {
            return TestSMProcedureState.STEP_1;
        }

        protected void rollback(TestProcEnv env) throws IOException, InterruptedException {
            if (this.isEofState()) {
                --this.stateCount;
            }
            try {
                try {
                    this.updateTimestamp();
                    this.rollbackState(env, (TestSMProcedureState)((Object)this.getCurrentState()));
                    throw new IOException();
                }
                catch (IOException iOException) {
                    --this.stateCount;
                    this.updateTimestamp();
                }
            }
            catch (Throwable throwable) {
                --this.stateCount;
                this.updateTimestamp();
                throw throwable;
            }
        }
    }

    public static class TestSMProcedure
    extends StateMachineProcedure<TestProcEnv, TestSMProcedureState> {
        protected StateMachineProcedure.Flow executeFromState(TestProcEnv env, TestSMProcedureState state) {
            LOG.info("EXEC " + (Object)((Object)state) + " " + (Object)((Object)this));
            env.execCount.incrementAndGet();
            switch (state) {
                case STEP_1: {
                    if (env.loop) break;
                    this.setNextState((Object)TestSMProcedureState.STEP_2);
                    break;
                }
                case STEP_2: {
                    this.addChildProcedure(new SimpleChildProcedure[]{new SimpleChildProcedure()});
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }

        protected boolean isRollbackSupported(TestSMProcedureState state) {
            return true;
        }

        protected void rollbackState(TestProcEnv env, TestSMProcedureState state) {
            LOG.info("ROLLBACK " + (Object)((Object)state) + " " + (Object)((Object)this));
            env.rollbackCount.incrementAndGet();
        }

        protected TestSMProcedureState getState(int stateId) {
            return TestSMProcedureState.values()[stateId];
        }

        protected int getStateId(TestSMProcedureState state) {
            return state.ordinal();
        }

        protected TestSMProcedureState getInitialState() {
            return TestSMProcedureState.STEP_1;
        }
    }

    public static enum TestSMProcedureState {
        STEP_1,
        STEP_2;

    }
}

