/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class IncreasingToUpperBoundRegionSplitPolicy
extends ConstantSizeRegionSplitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(IncreasingToUpperBoundRegionSplitPolicy.class);
    protected long initialSize;

    @Override
    public String toString() {
        return "IncreasingToUpperBoundRegionSplitPolicy{initialSize=" + this.initialSize + ", " + super.toString() + '}';
    }

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        Configuration conf = this.getConf();
        this.initialSize = conf.getLong("hbase.increasing.policy.initial.size", -1L);
        if (this.initialSize > 0L) {
            return;
        }
        TableDescriptor desc = region.getTableDescriptor();
        if (desc != null) {
            this.initialSize = 2L * desc.getMemStoreFlushSize();
        }
        if (this.initialSize <= 0L) {
            this.initialSize = 2L * conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
    }

    @Override
    protected boolean shouldSplit() {
        if (!this.canSplit()) {
            return false;
        }
        int tableRegionsCount = this.getCountOfCommonTableRegions();
        long sizeToCheck = this.getSizeToCheck(tableRegionsCount);
        boolean shouldSplit = this.isExceedSize(sizeToCheck);
        if (shouldSplit) {
            LOG.debug("regionsWithCommonTable={}", (Object)tableRegionsCount);
        }
        return shouldSplit;
    }

    private int getCountOfCommonTableRegions() {
        RegionServerServices rss = this.region.getRegionServerServices();
        if (rss == null) {
            return 0;
        }
        TableName tablename = this.region.getTableDescriptor().getTableName();
        int tableRegionsCount = 0;
        try {
            List hri = rss.getRegions(tablename);
            if (hri != null && !hri.isEmpty()) {
                tableRegionsCount = (int)hri.stream().filter(r -> r.getRegionInfo().getReplicaId() == 0).count();
            }
        }
        catch (IOException e) {
            LOG.debug("Failed getOnlineRegions " + tablename, (Throwable)e);
        }
        return tableRegionsCount;
    }

    protected long getSizeToCheck(int tableRegionsCount) {
        return tableRegionsCount == 0 || tableRegionsCount > 100 ? this.getDesiredMaxFileSize() : Math.min(this.getDesiredMaxFileSize(), this.initialSize * (long)tableRegionsCount * (long)tableRegionsCount * (long)tableRegionsCount);
    }
}

