/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.hadoop.mapred.ShuffleChannelHandler;
import org.apache.hadoop.mapred.ShuffleChannelHandlerContext;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.security.ssl.SSLFactory;

public class ShuffleChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final int MAX_CONTENT_LENGTH = 65536;
    private final ShuffleChannelHandlerContext handlerContext;
    private final SSLFactory sslFactory;

    public ShuffleChannelInitializer(ShuffleChannelHandlerContext ctx, SSLFactory sslFactory) {
        this.handlerContext = ctx;
        this.sslFactory = sslFactory;
    }

    public void initChannel(SocketChannel ch) throws GeneralSecurityException, IOException {
        ShuffleHandler.LOG.debug("ShuffleChannelInitializer init; channel='{}'", (Object)ch.id());
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslFactory != null) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.sslFactory.createSSLEngine()));
        }
        pipeline.addLast("http", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
        pipeline.addLast("chunking", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("shuffle", (ChannelHandler)new ShuffleChannelHandler(this.handlerContext));
        pipeline.addLast("timeout", (ChannelHandler)new ShuffleHandler.TimeoutHandler(this.handlerContext.connectionKeepAliveTimeOut));
    }
}

