/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.storefiletracker.DefaultStoreFileTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreFileTrackerForTest
extends DefaultStoreFileTracker {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileTrackerForTest.class);
    private static ConcurrentMap<String, BlockingQueue<StoreFileInfo>> trackedFiles = new ConcurrentHashMap<String, BlockingQueue<StoreFileInfo>>();
    private String storeId;

    public StoreFileTrackerForTest(Configuration conf, boolean isPrimaryReplica, StoreContext ctx) {
        super(conf, isPrimaryReplica, ctx);
        if (ctx != null && ctx.getRegionFileSystem() != null) {
            this.storeId = ctx.getRegionInfo().getEncodedName() + "-" + ctx.getFamily().getNameAsString();
            LOG.info("created storeId: {}", (Object)this.storeId);
            trackedFiles.computeIfAbsent(this.storeId, v -> new LinkedBlockingQueue());
        } else {
            LOG.info("ctx.getRegionFileSystem() returned null. Leaving storeId null.");
        }
    }

    protected void doAddNewStoreFiles(Collection<StoreFileInfo> newFiles) throws IOException {
        LOG.info("adding to storeId: {}", (Object)this.storeId);
        ((BlockingQueue)trackedFiles.get(this.storeId)).addAll(newFiles);
    }

    public List<StoreFileInfo> load() throws IOException {
        return new ArrayList<StoreFileInfo>((Collection)trackedFiles.get(this.storeId));
    }

    public static boolean tracked(String encodedRegionName, String family, Path file) {
        BlockingQueue files = (BlockingQueue)trackedFiles.get(encodedRegionName + "-" + family);
        return files != null && files.stream().anyMatch(s -> s.getPath().equals((Object)file));
    }

    public static void clear() {
        trackedFiles.clear();
    }
}

