/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestScannerTimeoutHandling {
    private static final Logger LOG = LoggerFactory.getLogger(TestScannerTimeoutHandling.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerTimeoutHandling.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final MetricsAssertHelper METRICS_ASSERT = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static final int TIMEOUT = 3000;
    private static final TableName TABLE_NAME = TableName.valueOf((String)"foo");
    private static Connection CONN;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.msginterval", 30000);
        conf.setInt("hbase.rpc.timeout", 3000);
        conf.setStrings("hbase.regionserver.impl", new String[]{RegionServerWithScanTimeout.class.getName()});
        conf.setInt("hbase.client.retries.number", 0);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, "0");
        CONN = ConnectionFactory.createConnection((Configuration)conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testExceededClientDeadline() throws Exception {
        Table table = CONN.getTable(TABLE_NAME);
        for (int i = 0; i < 10; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(new byte[]{48}, new byte[]{48}, new byte[]{48}));
        }
        try {
            ResultScanner scanner = table.getScanner(new Scan().setCaching(1).setMaxResultSize(1L));
            scanner.next();
        }
        catch (RetriesExhaustedException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof CallTimeoutException));
        }
        finally {
            RSRpcServicesWithScanTimeout.lock.tryLock(60L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)RSRpcServicesWithScanTimeout.scannerCount);
            Assert.assertTrue((boolean)RSRpcServicesWithScanTimeout.caughtTimeoutException);
            METRICS_ASSERT.assertCounterGt("exceptions.callTimedOut", 0L, (BaseSource)TEST_UTIL.getHBaseCluster().getRegionServer(0).getRpcServer().getMetrics().getMetricsSource());
        }
    }

    private static class RSRpcServicesWithScanTimeout
    extends RSRpcServices {
        private static boolean caughtTimeoutException = false;
        private static int scannerCount = -1;
        private static final Lock lock = new ReentrantLock();

        public RSRpcServicesWithScanTimeout(HRegionServer rs) throws IOException {
            super(rs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            String regionName = Bytes.toString((byte[])request.getRegion().getValue().toByteArray());
            if (regionName.contains(TABLE_NAME.getNameAsString())) {
                try {
                    if (!lock.tryLock(60L, TimeUnit.SECONDS)) {
                        throw new ServiceException("Failed to get lock");
                    }
                }
                catch (InterruptedException e) {
                    throw new ServiceException((Throwable)e);
                }
                try {
                    LOG.info("SLEEPING");
                    Thread.sleep(6000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    ClientProtos.ScanResponse e = super.scan(controller, request);
                    return e;
                }
                catch (ServiceException e) {
                    if (e.getCause() instanceof ScannerResetException && e.getCause().getCause() instanceof TimeoutIOException) {
                        LOG.info("caught EXPECTED exception in scan after sleep", (Throwable)e);
                        caughtTimeoutException = true;
                    } else {
                        LOG.warn("caught UNEXPECTED exception in scan after sleep", (Throwable)e);
                    }
                }
                finally {
                    scannerCount = this.getScannersCount();
                    lock.unlock();
                }
            }
            return super.scan(controller, request);
        }
    }

    private static class RegionServerWithScanTimeout
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public RegionServerWithScanTimeout(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new RSRpcServicesWithScanTimeout(this);
        }
    }
}

