/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceQuotaRefresherChore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestSpaceQuotaViolationPolicyRefresherChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotaViolationPolicyRefresherChore.class);
    private RegionServerSpaceQuotaManager manager;
    private RegionServerServices rss;
    private SpaceQuotaRefresherChore chore;
    private Configuration conf;
    private Connection conn;

    @Before
    public void setup() throws IOException {
        this.conf = HBaseConfiguration.create();
        this.rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        this.manager = (RegionServerSpaceQuotaManager)Mockito.mock(RegionServerSpaceQuotaManager.class);
        this.conn = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.manager.getRegionServerServices()).thenReturn((Object)this.rss);
        Mockito.when((Object)this.rss.getConfiguration()).thenReturn((Object)this.conf);
        this.chore = (SpaceQuotaRefresherChore)Mockito.mock(SpaceQuotaRefresherChore.class);
        Mockito.when((Object)this.chore.getConnection()).thenReturn((Object)this.conn);
        Mockito.when((Object)this.chore.getManager()).thenReturn((Object)this.manager);
        Mockito.when((Object)this.chore.checkQuotaTableExists()).thenReturn((Object)true);
        ((SpaceQuotaRefresherChore)Mockito.doCallRealMethod().when((Object)this.chore)).chore();
        Mockito.when((Object)this.chore.isInViolation((SpaceQuotaSnapshot)ArgumentMatchers.any())).thenCallRealMethod();
        ((SpaceQuotaRefresherChore)Mockito.doCallRealMethod().when((Object)this.chore)).extractQuotaSnapshot((Result)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testPoliciesAreEnforced() throws IOException {
        HashMap<TableName, SpaceQuotaSnapshot> policiesToEnforce = new HashMap<TableName, SpaceQuotaSnapshot>();
        policiesToEnforce.put(TableName.valueOf((String)"table1"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.DISABLE), 1024L, 512L));
        policiesToEnforce.put(TableName.valueOf((String)"table2"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_INSERTS), 2048L, 512L));
        policiesToEnforce.put(TableName.valueOf((String)"table3"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES), 4096L, 512L));
        policiesToEnforce.put(TableName.valueOf((String)"table4"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES_COMPACTIONS), 8192L, 512L));
        Mockito.when((Object)this.manager.copyQuotaSnapshots()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.chore.fetchSnapshotsFromQuotaTable()).thenReturn(policiesToEnforce);
        this.chore.chore();
        for (Map.Entry entry : policiesToEnforce.entrySet()) {
            ((RegionServerSpaceQuotaManager)Mockito.verify((Object)this.manager)).enforceViolationPolicy((TableName)entry.getKey(), (SpaceQuotaSnapshot)entry.getValue());
            ((RegionServerSpaceQuotaManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).disableViolationPolicyEnforcement((TableName)entry.getKey());
        }
    }

    @Test
    public void testOldPoliciesAreRemoved() throws IOException {
        HashMap<TableName, SpaceQuotaSnapshot> previousPolicies = new HashMap<TableName, SpaceQuotaSnapshot>();
        previousPolicies.put(TableName.valueOf((String)"table3"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES), 4096L, 512L));
        previousPolicies.put(TableName.valueOf((String)"table4"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES), 8192L, 512L));
        HashMap<TableName, SpaceQuotaSnapshot> policiesToEnforce = new HashMap<TableName, SpaceQuotaSnapshot>();
        policiesToEnforce.put(TableName.valueOf((String)"table1"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.DISABLE), 1024L, 512L));
        policiesToEnforce.put(TableName.valueOf((String)"table2"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_INSERTS), 2048L, 512L));
        policiesToEnforce.put(TableName.valueOf((String)"table3"), new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), 256L, 512L));
        policiesToEnforce.put(TableName.valueOf((String)"table4"), new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), 128L, 512L));
        Mockito.when((Object)this.manager.copyQuotaSnapshots()).thenReturn(previousPolicies);
        Mockito.when((Object)this.chore.fetchSnapshotsFromQuotaTable()).thenReturn(policiesToEnforce);
        this.chore.chore();
        ((RegionServerSpaceQuotaManager)Mockito.verify((Object)this.manager)).enforceViolationPolicy(TableName.valueOf((String)"table1"), (SpaceQuotaSnapshot)policiesToEnforce.get(TableName.valueOf((String)"table1")));
        ((RegionServerSpaceQuotaManager)Mockito.verify((Object)this.manager)).enforceViolationPolicy(TableName.valueOf((String)"table2"), (SpaceQuotaSnapshot)policiesToEnforce.get(TableName.valueOf((String)"table2")));
        ((RegionServerSpaceQuotaManager)Mockito.verify((Object)this.manager)).disableViolationPolicyEnforcement(TableName.valueOf((String)"table3"));
        ((RegionServerSpaceQuotaManager)Mockito.verify((Object)this.manager)).disableViolationPolicyEnforcement(TableName.valueOf((String)"table4"));
    }

    @Test
    public void testNewPolicyOverridesOld() throws IOException {
        HashMap<TableName, SpaceQuotaSnapshot> policiesToEnforce = new HashMap<TableName, SpaceQuotaSnapshot>();
        policiesToEnforce.put(TableName.valueOf((String)"table1"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.DISABLE), 1024L, 512L));
        policiesToEnforce.put(TableName.valueOf((String)"table2"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES), 2048L, 512L));
        policiesToEnforce.put(TableName.valueOf((String)"table3"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_INSERTS), 4096L, 512L));
        HashMap<TableName, SpaceQuotaSnapshot> previousPolicies = new HashMap<TableName, SpaceQuotaSnapshot>();
        previousPolicies.put(TableName.valueOf((String)"table1"), new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES), 8192L, 512L));
        Mockito.when((Object)this.manager.getActivePoliciesAsMap()).thenReturn(previousPolicies);
        Mockito.when((Object)this.chore.fetchSnapshotsFromQuotaTable()).thenReturn(policiesToEnforce);
        this.chore.chore();
        for (Map.Entry entry : policiesToEnforce.entrySet()) {
            ((RegionServerSpaceQuotaManager)Mockito.verify((Object)this.manager)).enforceViolationPolicy((TableName)entry.getKey(), (SpaceQuotaSnapshot)entry.getValue());
        }
        ((RegionServerSpaceQuotaManager)Mockito.verify((Object)this.manager, (VerificationMode)Mockito.never())).disableViolationPolicyEnforcement(TableName.valueOf((String)"table1"));
    }

    @Test
    public void testMissingAllColumns() throws IOException {
        Mockito.when((Object)this.chore.fetchSnapshotsFromQuotaTable()).thenCallRealMethod();
        ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
        Table quotaTable = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME)).thenReturn((Object)quotaTable);
        Mockito.when((Object)quotaTable.getScanner((Scan)ArgumentMatchers.any(Scan.class))).thenReturn((Object)scanner);
        ArrayList<Result> results = new ArrayList<Result>();
        results.add(Result.create(Collections.emptyList()));
        Mockito.when((Object)scanner.iterator()).thenReturn(results.iterator());
        try {
            this.chore.fetchSnapshotsFromQuotaTable();
            Assert.fail((String)"Expected an IOException, but did not receive one.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingDesiredColumn() throws IOException {
        Mockito.when((Object)this.chore.fetchSnapshotsFromQuotaTable()).thenCallRealMethod();
        ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
        Table quotaTable = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME)).thenReturn((Object)quotaTable);
        Mockito.when((Object)quotaTable.getScanner((Scan)ArgumentMatchers.any(Scan.class))).thenReturn((Object)scanner);
        ArrayList<Result> results = new ArrayList<Result>();
        KeyValue c = new KeyValue(Bytes.toBytes((String)"t:inviolation"), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"s"), new byte[0]);
        results.add(Result.create(Collections.singletonList(c)));
        Mockito.when((Object)scanner.iterator()).thenReturn(results.iterator());
        try {
            this.chore.fetchSnapshotsFromQuotaTable();
            Assert.fail((String)"Expected an IOException, but did not receive one.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testParsingError() throws IOException {
        Mockito.when((Object)this.chore.fetchSnapshotsFromQuotaTable()).thenCallRealMethod();
        ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
        Table quotaTable = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME)).thenReturn((Object)quotaTable);
        Mockito.when((Object)quotaTable.getScanner((Scan)ArgumentMatchers.any(Scan.class))).thenReturn((Object)scanner);
        ArrayList<Result> results = new ArrayList<Result>();
        KeyValue c = new KeyValue(Bytes.toBytes((String)"t:inviolation"), Bytes.toBytes((String)"u"), Bytes.toBytes((String)"v"), new byte[0]);
        results.add(Result.create(Collections.singletonList(c)));
        Mockito.when((Object)scanner.iterator()).thenReturn(results.iterator());
        try {
            this.chore.fetchSnapshotsFromQuotaTable();
            Assert.fail((String)"Expected an IOException, but did not receive one.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

