/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.region.MasterRegionTestBase;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRegionRpcTimeout
extends MasterRegionTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRegionRpcTimeout.class);

    @Test
    public void testRpcTimeout() throws IOException {
        RpcCall call = (RpcCall)Mockito.mock(RpcCall.class);
        Mockito.when((Object)call.getDeadline()).thenReturn((Object)(EnvironmentEdgeManager.currentTime() - 10000L));
        RpcServer.setCurrentCall((RpcCall)call);
        this.region.update(r -> r.put(new Put(Bytes.toBytes((String)"row")).addColumn(CF1, QUALIFIER, Bytes.toBytes((String)"value"))));
        Assert.assertSame((Object)call, RpcServer.getCurrentCall().get());
    }
}

