/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.http;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ConnectionRule;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.hbck.HbckChore;
import org.apache.hadoop.hbase.master.hbck.HbckReport;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitorReport;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.javax.ws.rs.NotAcceptableException;
import org.apache.hbase.thirdparty.javax.ws.rs.client.Client;
import org.apache.hbase.thirdparty.javax.ws.rs.client.ClientBuilder;
import org.apache.hbase.thirdparty.javax.ws.rs.client.WebTarget;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestHbckMetricsResource {
    private static final Logger LOG = LoggerFactory.getLogger(TestHbckMetricsResource.class);
    private static final long reportStartTime = 123456789000L;
    private static final long reportEndTime = 234567890000L;
    private static final String regionId1 = "regionId1";
    private static final String regionId2 = "regionId2";
    private static final String localhost1 = "localhost1";
    private static final String localhost2 = "localhost2";
    private static final String port = "16010";
    private static final String hostStartCode = "123456789";
    private static final String path1 = "hdfs://path1";
    private static final String path2 = "hdfs://path2";
    private static final String metaRegionID = RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedName();
    private static final String metaTableName = RegionInfoBuilder.FIRST_META_REGIONINFO.getTable().getNameAsString();
    private static final String quoteColon = "\":";
    private static final String quote = "\"";
    private static final String regionId = "\"region_id\":";
    private static final String regionHdfsPath = "\"region_hdfs_path\":";
    private static final String rsName = "\"rs_name\":";
    private static final String hostName = "\"host_name\":";
    private static final String hostPort = "\"host_port\":";
    private static final String startCode = "\"start_code\":";
    private static final String serverNameInMeta = "\"server_name_in_meta\":";
    private static final String listOfServers = "\"list_of_servers\":";
    private static final String region1Info = "\"region1_info\":";
    private static final String region2Info = "\"region2_info\":";
    private static final String regionInfo = "\"region_info\":";
    private static final String serverName = "\"server_name\":";
    private static final String tableName = "\"table_name\":";
    private static final String dataStartsWith = "{\"data\":[";
    private static final String dataEndsWith = "]}";
    private static final String hbckReportStartTime = "\"hbck_report_start_time\":";
    private static final String hbckReportEndTime = "\"hbck_report_end_time\":";
    private static final String hbckOrphanRegionOnFS = "\"hbck_orphan_regions_on_fs\":";
    private static final String hbckOrphanRegionOnRS = "\"hbck_orphan_regions_on_rs\":";
    private static final String hbckInconsistentRegion = "\"hbck_inconsistent_regions\":";
    private static final String hbckHoles = "\"hbck_holes\":";
    private static final String hbckOverlaps = "\"hbck_overlaps\":";
    private static final String hbckUnknownServers = "\"hbck_unknown_servers\":";
    private static final String hbckEmptyRegionInfo = "\"hbck_empty_region_info\":";
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHbckMetricsResource.class);
    private static final MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().setMiniClusterOption(StartMiniClusterOption.builder().numZkServers(3).numMasters(3).numDataNodes(3).build()).setConfiguration(() -> {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.info.port", 0);
        conf.set("hbase.http.jersey.tracing.type", "ON_DEMAND");
        return conf;
    }).build();
    private static final ConnectionRule connectionRule = ConnectionRule.createAsyncConnectionRule(miniClusterRule::createAsyncConnection);
    private static final ClassSetup classRule = new ClassSetup(connectionRule::getAsyncConnection);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)miniClusterRule).around((TestRule)connectionRule).around((TestRule)classRule);

    @Test
    public void testGetRoot() {
        String response = (String)classRule.getTarget().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        LOG.info("HBCK JSON Response : " + response);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)hbckReportStartTime), Matchers.containsString((String)hbckReportEndTime), Matchers.containsString((String)hbckOrphanRegionOnFS), Matchers.containsString((String)hbckOrphanRegionOnRS), Matchers.containsString((String)hbckInconsistentRegion), Matchers.containsString((String)hbckHoles), Matchers.containsString((String)hbckOverlaps), Matchers.containsString((String)hbckUnknownServers), Matchers.containsString((String)hbckEmptyRegionInfo), Matchers.containsString((String)Objects.toString(123456789000L)), Matchers.containsString((String)Objects.toString(234567890000L))}));
    }

    @Test
    public void testGetRootHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetOrphanRegionOnFS() {
        String response = (String)classRule.getTarget().path("orphan-regions-on-fs").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        LOG.info("HBCK Response for resource orphan-regions-on-fs : " + response);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.startsWith((String)dataStartsWith), Matchers.endsWith((String)dataEndsWith), Matchers.containsString((String)regionId), Matchers.containsString((String)regionHdfsPath), Matchers.containsString((String)regionId1), Matchers.containsString((String)regionId2), Matchers.containsString((String)path1), Matchers.containsString((String)path2)}));
    }

    @Test
    public void testGetOrphanRegionOnFSHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("orphan-regions-on-fs").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetOrphanRegionOnRS() {
        String response = (String)classRule.getTarget().path("orphan-regions-on-rs").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        LOG.info("HBCK Response for resource orphan-regions-on-rs : " + response);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.startsWith((String)dataStartsWith), Matchers.endsWith((String)dataEndsWith), Matchers.containsString((String)regionId), Matchers.containsString((String)rsName), Matchers.containsString((String)hostName), Matchers.containsString((String)hostPort), Matchers.containsString((String)startCode), Matchers.containsString((String)regionId1), Matchers.containsString((String)regionId2), Matchers.containsString((String)localhost1), Matchers.containsString((String)localhost2), Matchers.containsString((String)port), Matchers.containsString((String)hostStartCode)}));
    }

    @Test
    public void testGetOrphanRegionOnRSHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("orphan-regions-on-rs").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetInconsistentRegions() {
        String response = (String)classRule.getTarget().path("inconsistent-regions").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        LOG.info("HBCK Response for resource inconsistent-regions : " + response);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.startsWith((String)dataStartsWith), Matchers.endsWith((String)dataEndsWith), Matchers.containsString((String)hostName), Matchers.containsString((String)hostPort), Matchers.containsString((String)startCode), Matchers.containsString((String)listOfServers), Matchers.containsString((String)regionId1), Matchers.containsString((String)regionId2), Matchers.containsString((String)regionId), Matchers.containsString((String)serverNameInMeta), Matchers.containsString((String)localhost1), Matchers.containsString((String)localhost2), Matchers.containsString((String)port), Matchers.containsString((String)hostStartCode)}));
    }

    @Test
    public void testGetInconsistentRegionsHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("inconsistent-regions").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetRegionHoles() {
        String response = (String)classRule.getTarget().path("region-holes").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        LOG.info("HBCK Response for resource region-holes : " + response);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.startsWith((String)dataStartsWith), Matchers.endsWith((String)dataEndsWith), Matchers.containsString((String)region1Info), Matchers.containsString((String)region2Info), Matchers.containsString((String)regionId), Matchers.containsString((String)tableName), Matchers.containsString((String)metaRegionID), Matchers.containsString((String)metaTableName)}));
    }

    @Test
    public void testGetRegionHolesHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("region-holes").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetRegionOverlaps() {
        String response = (String)classRule.getTarget().path("region-overlaps").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        LOG.info("HBCK Response for resource region-overlaps : " + response);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.startsWith((String)dataStartsWith), Matchers.endsWith((String)dataEndsWith), Matchers.containsString((String)regionId), Matchers.containsString((String)tableName), Matchers.containsString((String)region2Info), Matchers.containsString((String)region2Info), Matchers.containsString((String)metaRegionID), Matchers.containsString((String)metaTableName)}));
    }

    @Test
    public void testGetRegionOverlapsHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("region-overlaps").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetUnkownServers() {
        String response = (String)classRule.getTarget().path("unknown-servers").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        LOG.info("HBCK Response for resource unknown-servers : " + response);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.startsWith((String)dataStartsWith), Matchers.endsWith((String)dataEndsWith), Matchers.containsString((String)regionInfo), Matchers.containsString((String)regionId), Matchers.containsString((String)tableName), Matchers.containsString((String)serverName), Matchers.containsString((String)serverName), Matchers.containsString((String)port), Matchers.containsString((String)startCode), Matchers.containsString((String)metaRegionID), Matchers.containsString((String)metaTableName), Matchers.containsString((String)localhost1), Matchers.containsString((String)localhost2), Matchers.containsString((String)port), Matchers.containsString((String)startCode)}));
    }

    @Test
    public void testGetUnkownServersHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("unknown-servers").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    @Test
    public void testGetEmptyRegionInfo() {
        String response = (String)classRule.getTarget().path("empty-regioninfo").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        LOG.info("HBCK Response for resource empty-regioninfo : " + response);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)dataStartsWith), (Matcher)Matchers.endsWith((String)dataEndsWith), (Matcher)Matchers.containsString((String)regionInfo), (Matcher)Matchers.containsString((String)regionId1), (Matcher)Matchers.containsString((String)regionId2)));
    }

    @Test
    public void testGetEmptyRegionInfoHtml() {
        Assert.assertThrows(NotAcceptableException.class, () -> {
            String cfr_ignored_0 = (String)classRule.getTarget().path("empty-regioninfo").request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).header("X-Jersey-Tracing-Accept", (Object)true).get(String.class);
        });
    }

    private static final class ClassSetup
    extends ExternalResource {
        private final Supplier<AsyncConnection> connectionSupplier;
        private final TableName tableName;
        private AsyncAdmin admin;
        private WebTarget target;

        public ClassSetup(Supplier<AsyncConnection> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
            this.tableName = TableName.valueOf((String)TestHbckMetricsResource.class.getSimpleName());
        }

        public WebTarget getTarget() {
            return this.target;
        }

        protected void before() throws Throwable {
            AsyncConnection conn = this.connectionSupplier.get();
            this.admin = conn.getAdmin();
            TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"c")).build()).setDurability(Durability.SKIP_WAL).build();
            this.admin.createTable(tableDescriptor).get();
            HMaster master = miniClusterRule.getTestingUtility().getMiniHBaseCluster().getMaster();
            HbckChore hbckChore = (HbckChore)Mockito.mock(HbckChore.class);
            HbckReport hbckReport = (HbckReport)Mockito.mock(HbckReport.class);
            CatalogJanitor catalogJanitorChore = (CatalogJanitor)Mockito.mock(CatalogJanitor.class);
            CatalogJanitorReport catalogJanitorReport = (CatalogJanitorReport)Mockito.mock(CatalogJanitorReport.class);
            master.setHbckChoreForTesting(hbckChore);
            master.setCatalogJanitorChoreForTesting(catalogJanitorChore);
            ServerName server1 = ServerName.valueOf((String)TestHbckMetricsResource.localhost1, (int)Integer.parseInt(TestHbckMetricsResource.port), (long)Integer.parseInt(TestHbckMetricsResource.hostStartCode));
            ServerName server2 = ServerName.valueOf((String)TestHbckMetricsResource.localhost2, (int)Integer.parseInt(TestHbckMetricsResource.port), (long)Integer.parseInt(TestHbckMetricsResource.hostStartCode));
            Path hdfsPath1 = new Path(TestHbckMetricsResource.path1);
            Path hdfsPath2 = new Path(TestHbckMetricsResource.path2);
            HashMap<String, ServerName> mapOfOrphanRegionsOnRS = new HashMap<String, ServerName>();
            mapOfOrphanRegionsOnRS.put(TestHbckMetricsResource.regionId1, server1);
            mapOfOrphanRegionsOnRS.put(TestHbckMetricsResource.regionId2, server2);
            HashMap<String, Path> mapOfOrphanRegionOnFS = new HashMap<String, Path>();
            mapOfOrphanRegionOnFS.put(TestHbckMetricsResource.regionId1, hdfsPath1);
            mapOfOrphanRegionOnFS.put(TestHbckMetricsResource.regionId2, hdfsPath2);
            HashMap<String, Pair> mapOfInconsistentRegions = new HashMap<String, Pair>();
            mapOfInconsistentRegions.put(TestHbckMetricsResource.regionId1, new Pair((Object)server1, Arrays.asList(server1, server2)));
            mapOfInconsistentRegions.put(TestHbckMetricsResource.regionId2, new Pair((Object)server2, Arrays.asList(server1, server2)));
            ArrayList<Pair> listOfRegion = new ArrayList<Pair>();
            listOfRegion.add(new Pair((Object)RegionInfoBuilder.FIRST_META_REGIONINFO, (Object)RegionInfoBuilder.FIRST_META_REGIONINFO));
            listOfRegion.add(new Pair((Object)RegionInfoBuilder.FIRST_META_REGIONINFO, (Object)RegionInfoBuilder.FIRST_META_REGIONINFO));
            ArrayList<Pair> listOfUnknownServers = new ArrayList<Pair>();
            listOfUnknownServers.add(new Pair((Object)RegionInfoBuilder.FIRST_META_REGIONINFO, (Object)server1));
            listOfUnknownServers.add(new Pair((Object)RegionInfoBuilder.FIRST_META_REGIONINFO, (Object)server2));
            ArrayList<byte[]> listOfEmptyRegionInfo = new ArrayList<byte[]>();
            listOfEmptyRegionInfo.add(TestHbckMetricsResource.regionId1.getBytes());
            listOfEmptyRegionInfo.add(TestHbckMetricsResource.regionId2.getBytes());
            Mockito.when((Object)hbckReport.getCheckingStartTimestamp()).thenReturn((Object)Instant.ofEpochMilli(123456789000L));
            Mockito.when((Object)hbckReport.getCheckingEndTimestamp()).thenReturn((Object)Instant.ofEpochSecond(234567890000L));
            Mockito.when((Object)hbckReport.getOrphanRegionsOnFS()).thenReturn(mapOfOrphanRegionOnFS);
            Mockito.when((Object)hbckReport.getOrphanRegionsOnRS()).thenReturn(mapOfOrphanRegionsOnRS);
            Mockito.when((Object)hbckReport.getInconsistentRegions()).thenReturn(mapOfInconsistentRegions);
            Mockito.when((Object)catalogJanitorReport.getHoles()).thenReturn(listOfRegion);
            Mockito.when((Object)catalogJanitorReport.getOverlaps()).thenReturn(listOfRegion);
            Mockito.when((Object)catalogJanitorReport.getUnknownServers()).thenReturn(listOfUnknownServers);
            Mockito.when((Object)catalogJanitorReport.getEmptyRegionInfo()).thenReturn(listOfEmptyRegionInfo);
            ((HbckChore)Mockito.doReturn((Object)hbckReport).when((Object)hbckChore)).getLastReport();
            ((CatalogJanitor)Mockito.doReturn((Object)catalogJanitorReport).when((Object)catalogJanitorChore)).getLastReport();
            String baseUrl = (String)((CompletableFuture)((CompletableFuture)this.admin.getMaster().thenApply(ServerName::getHostname)).thenCombine((CompletionStage)this.admin.getMasterInfoPort(), (hostName, infoPort) -> "http://" + hostName + ":" + infoPort)).get();
            Client client = ClientBuilder.newClient();
            this.target = client.target(baseUrl).path("hbck/hbck-metrics");
        }

        protected void after() {
            TableName tableName = TableName.valueOf((String)"test");
            try {
                ((CompletableFuture)this.admin.tableExists(tableName).thenCompose(val -> {
                    if (val.booleanValue()) {
                        return this.admin.disableTable(tableName).thenCompose(ignored -> this.admin.deleteTable(tableName));
                    }
                    return CompletableFuture.completedFuture(null);
                })).get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

